unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons,
  SDL_wavelet, SDL_NumLab, SDL_rchart;

type
  TForm1 = class(TForm)
    DWT1: TWavelet1D;
    RC1: TRChart;
    Panel1: TPanel;
    SBarOrder: TScrollBar;
    Label2: TLabel;
    NLabOrder: TNumLab;
    Label1: TLabel;
    SBarCoeff: TScrollBar;
    NLabCoeff: TNumLab;
    BButExit: TBitBtn;
    procedure SBarCoeffChange(Sender: TObject);
    procedure SBarOrderChange(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure CalcAndShow;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

(******************************************************************************)
procedure TForm1.SBarCoeffChange(Sender: TObject);
(******************************************************************************)

begin
CalcAndShow;
end;

(******************************************************************************)
procedure TForm1.CalcAndShow;
(******************************************************************************)

var
  i : integer;

begin
NLabCoeff.Value := SBarCoeff.Position;
NLabOrder.Value := SBarOrder.Position;
DWT1.Clear;
DWT1.Order := SBarOrder.Position;
DWT1.Data[SBarCoeff.Position] := 1;
DWT1.InverseTransform(10);
RC1.ClearGraf;
RC1.MoveTo(1,DWT1.Data[1]);
for i:=1 to DWT1.Size do
  begin
  RC1.DrawTo (i, DWT1.Data[i]);
  end;
RC1.AutoRangeYOnly(1,5);
RC1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.SBarOrderChange(Sender: TObject);
(******************************************************************************)

begin
CalcAndShow;
end;

(******************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

begin
CalcAndShow;
end;

end.
