unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SDL_sline, StdCtrls, ExtCtrls, SDL_NumLab, SDL_rchart, Buttons;

type
  TForm1 = class(TForm)
    RC1: TRChart;
    Panel1: TPanel;
    NLabX: TNumLab;
    NLabY: TNumLab;
    NLabDist: TNumLab;
    SBarAngle: TScrollBar;
    L1: TSLine;
    L2: TSLine;
    L3: TSLine;
    Label1: TLabel;
    Label2: TLabel;
    Memo1: TMemo;
    BButExit: TBitBtn;
    procedure SBarAngleChange(Sender: TObject);
    procedure RC1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
    procedure FormShow(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
  private
    P1x, P1y    : double;
    P2x, P2y    : double;
    P3x, P3y    : double;
    P4x, P4y    : double;
    procedure Showlines;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_math1;

(******************************************************************************)
procedure TForm1.Showlines;
(******************************************************************************)

var
  x,y   : double;
  x1,y1 : double;
  x2,y2 : double;

begin
RC1.SuppressPaint := true;
RC1.ClearGraf;
RC1.ClassDefault := 0;
RC1.DataTag := 0;
RC1.DataColor := clBlue;

L1.ClipBox (RC1.Scale1X.RangeLow, RC1.Scale1Y.RangeLow,
            RC1.Scale1X.RangeHigh, RC1.Scale1Y.RangeHigh,
            x1, y1, x2, y2);
RC1.MoveTo(x1,y1);
RC1.DrawTo(x2,y2);

RC1.DataColor := clBlue;
L2.ClipBox (RC1.Scale1X.RangeLow, RC1.Scale1Y.RangeLow,
            RC1.Scale1X.RangeHigh, RC1.Scale1Y.RangeHigh,
            x1, y1, x2, y2);
RC1.MoveTo(x1,y1);
RC1.DrawTo(x2,y2);

RC1.DataColor := clRed;
L3.ClipBox (RC1.Scale1X.RangeLow, RC1.Scale1Y.RangeLow,
            RC1.Scale1X.RangeHigh, RC1.Scale1Y.RangeHigh,
            x1, y1, x2, y2);
RC1.MoveTo(x1,y1);
RC1.DrawTo(x2,y2);

RC1.DataColor := clGray;
if L1.InterSection (L2, x,y) then
  begin
  NLabX.Value := x;
  NLabY.Value := y;
  RC1.MarkAt (x,y,12);
  RC1.Text (x, y, 10, '  I1');
  end;
if L1.InterSection (L3, x,y) then
  begin
  RC1.MarkAt (x,y,12);
  RC1.Text (x, y, 10, '  I3');
  end;
if L2.InterSection (L3, x,y) then
  begin
  RC1.MarkAt (x,y,12);
  RC1.Text (x, y, 10, '  I2');
  end;

RC1.TextAlignment := taLeftJustify;
RC1.DataColor := clBlue;
RC1.DataTag := 1;
RC1.ClassDefault := 99;
RC1.MarkAt(p1x, p1y, 9);
RC1.Text (p1x, p1y, 10, '  P1');
RC1.DataTag := 2;
RC1.MarkAt(p2x, p2y, 9);
RC1.Text (p2x, p2y, 10, '  P2');
RC1.DataColor := clBlue;
RC1.DataTag := 3;
RC1.MarkAt(p3x, p3y, 9);
RC1.Text (p3x, p3y, 10, '  P3');
RC1.DataColor := clRed;
RC1.DataTag := 4;
RC1.MarkAt(p4x, p4y, 9);
RC1.Text (p4x, p4y, 10, '  P4');
RC1.ClassDefault := 0;
RC1.DataTag := 0;
RC1.SuppressPaint := false;
end;



(******************************************************************************)
procedure TForm1.SBarAngleChange(Sender: TObject);
(******************************************************************************)

begin
L3.LineThroughPoint(p4x, p4y, SBarAngle.Position/1000);
NLabDist.Value := SBarAngle.Position/1000/Pi*180;
ShowLines;
end;

(******************************************************************************)
procedure TForm1.RC1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(******************************************************************************)

var
  Dist  : double;
  itix  : integer;
  rcData: TRcChartItem;

begin
if ssLeft in Shift then
  begin
  itix := RC1.FindNearestItemScreen (RC1.MousePosX, RC1.MousePosY, tkMarkAt, 99, Dist);
  rcdata := RC1.DataContainer[itix];
  rcdata.x := RC1.MousePosX;
  rcdata.y := RC1.MousePosY;
  RC1.DataContainer[itix] := rcdata;
  case rcdata.Tag of
    1 : begin
        p1x := rcdata.x;
        p1y := rcdata.y;
        end;
    2 : begin
        p2x := rcdata.x;
        p2y := rcdata.y;
        end;
    3 : begin
        p3x := rcdata.x;
        p3y := rcdata.y;
        end;
    4 : begin
        p4x := rcdata.x;
        p4y := rcdata.y;
        end;
  end;
  L1.LineFrom2Points(p1x, p1y, p2x, p2y);
  L2.NormalLine(p3x, p3y, L1);
  L3.LineThroughPoint(p4x, p4y, SBarAngle.Position/1000);
  ShowLines;
  end;
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

begin
P1x := -0.5;
P1y := -0.5;
P2x := +0.5;
P2y := -0.3;
P3x := +0.3;
P3y := +0.1;
L1.LineFrom2Points(p1x, p1y, p2x, p2y);
L2.NormalLine(p3x, p3y, L1);
L3.LineThroughPoint(p4x, p4y, SBarAngle.Position/1000);
ShowLines;
end;

(******************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

end.
