unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Menus,
  SDL_Colsel, SDL_NumLab, SDL_geomap, SDL_NumIO;

type
  TFrmMap = class(TForm)
    GM: TGeoMap;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    NLabY: TNumLab;
    NLabX: TNumLab;
    NLabLong: TNumLab;
    NLabLat: TNumLab;
    BButClearMap: TBitBtn;
    SBAddLandmark: TSpeedButton;
    SBRemoveLM: TSpeedButton;
    BButLoadMap: TBitBtn;
    RGShowGrat: TRadioGroup;
    BButExit: TBitBtn;
    BButStoreMap: TBitBtn;
    SaveDialog1: TSaveDialog;
    BButLoadMapImg: TBitBtn;
    SBAddCalib: TSpeedButton;
    SBRemoveCalib: TSpeedButton;
    SBarSize: TScrollBar;
    SBarAngle: TScrollBar;
    RGLMType: TRadioGroup;
    SBarHead: TScrollBar;
    CBoxTransp: TCheckBox;
    CSelForegnd: TColSel;
    CSelBackGnd: TColSel;
    LblColorFg: TLabel;
    LblColorBg: TLabel;
    NLabHeadSize: TNumLab;
    NLabAngle: TNumLab;
    NLabLMSize: TNumLab;
    Bevel1: TBevel;
    Label1: TLabel;
    BButLoadLM: TBitBtn;
    BButSaveLM: TBitBtn;
    CBoxCalibModel: TComboBox;
    Label2: TLabel;
    SBOops: TSpeedButton;
    SBMoveCalibPoint: TSpeedButton;
    NLabMag: TNumLab;
    SBZoomIn: TSpeedButton;
    SBZoomOut: TSpeedButton;
    Label3: TLabel;
    CBoxMouseAct: TComboBox;
    Label4: TLabel;
    NIOUTMZone: TNumIO2;
    RGHemisph: TRadioGroup;
    procedure BButLoadMapImgClick(Sender: TObject);
    procedure GMMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GMMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RGShowGratClick(Sender: TObject);
    procedure ButStoreMapClick(Sender: TObject);
    procedure ButLoadMapClick(Sender: TObject);
    procedure SBAddLandmarkClick(Sender: TObject);
    procedure BButClearMapClick(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure SBAddCalibClick(Sender: TObject);
    procedure SBRemoveCalibClick(Sender: TObject);
    procedure RGLMTypeClick(Sender: TObject);
    procedure SBarSizeChange(Sender: TObject);
    procedure SBarHeadChange(Sender: TObject);
    procedure SBarAngleChange(Sender: TObject);
    procedure BButSaveLMClick(Sender: TObject);
    procedure BButLoadLMClick(Sender: TObject);
    procedure CBoxCalibModelChange(Sender: TObject);
    procedure SBOopsClick(Sender: TObject);
    procedure SBMoveCalibPointClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SBZoomOutClick(Sender: TObject);
    procedure SBZoomInClick(Sender: TObject);
    procedure CBoxMouseActChange(Sender: TObject);
    procedure GMZoomPan(Sender: TObject);
    procedure NLabMagClick(Sender: TObject);
    procedure NIOUTMZoneChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMap: TFrmMap;

implementation

uses
  SDL_sdlbase, SDL_geobasics, SDL_filesys, SDL_univconst, graticule, SDL_stringl;

{$R *.dfm}

(******************************************************************************)
procedure TFrmMap.BButLoadMapImgClick(Sender: TObject);
(******************************************************************************)

begin
OpenDialog1.Filter := 'Map Images|*.bmp;*.jpg';
if OpenDialog1.Execute then
  begin
  GM.MapImgFile := OpenDialog1.FileName;
  GM.ClearCalibData;
  SBAddCalib.Enabled := true;
  SBRemoveCalib.Enabled := true;
  SBMoveCalibPoint.Enabled := true;
  end;
end;


(******************************************************************************)
procedure TFrmMap.GMMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(******************************************************************************)

var
  valid      : boolean;
  found      : boolean;
  idx, jdx   : integer;
  mindist    : double;
  imin, jmin : integer;
  d          : double;
  CQ         : TCalibData;
  APoint     : TPoint;

begin
APoint := GM.ControlToMapImage(Point(x,y));
NLabX.value := APoint.X;
NLabY.Value := APoint.Y;
NLabLat.Value := GM.CalcLatitude (APoint, valid);
NLabLat.Empty := not valid;
NLabLong.Value := GM.CalcLongitude (APoint, valid);
NLabLong.Empty := not valid;

SBAddLandMark.Enabled := valid;
SBRemoveLM.Enabled := valid;
if (ssLeft in Shift) and SBMoveCalibPoint.Down then
  begin
  CQ := GM.CalibData;
  case GM.CalibModel of
      cmParabolicIp : begin
                      mindist := uc_MaxDouble;     // find nearest CalQuad
                      imin := 1;
                      jmin := 1;
                      found := false;
                      for jdx:=1 to CQ.NumCalLines do
                        for idx:=1 to CQ.CalLines[jdx].NumPoints do
                          begin
                          d := sqr(CQ.CalLines[jdx].CalPoints[idx].X-APoint.X)+
                               sqr(CQ.CalLines[jdx].CalPoints[idx].Y-APoint.Y);
                          if d < mindist then
                            begin
                            mindist := d;
                            imin := idx;
                            jmin := jdx;
                            found := true;
                            end;
                          end;
                      if found then
                        begin
                        CQ.CalLines[jmin].CalPoints[imin].X := APoint.X;
                        CQ.CalLines[jmin].CalPoints[imin].Y := APoint.Y;
                        GM.CalibData := CQ;
                        end;
                      end;
   cmConicConformal,
cmMillerCylindrical,
    cmBiquadraticPn : begin
                      mindist := uc_MaxDouble;     // find nearest CalQuad
                      imin := 1;
                      found := false;
                      for idx:=1 to CQ.NumCalQuads do
                        begin
                        d := sqr(CQ.CalQuads[idx].MapX-APoint.X)+
                             sqr(CQ.CalQuads[idx].MapY-APoint.Y);
                        if d < mindist then
                          begin
                          mindist := d;
                          imin := idx;
                          found := true;
                          end;
                        end;
                      if found then
                        begin
                        CQ.CalQuads[imin].MapX := APoint.X;
                        CQ.CalQuads[imin].MapY := APoint.Y;
                        GM.CalibData := CQ;
                        end;
                      end;
  end;
  GM.ReCalcCalibration;
  end;
end;

(******************************************************************************)
procedure TFrmMap.GMMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
(******************************************************************************)

var
  long, lat : double;
  valid     : boolean;

begin
if SBAddCalib.Down then
  begin
  case CBoxCalibModel.ItemIndex of
      ord(cmParabolicIp) : begin
                           FrmGratPoint.NIOLat.Visible := false;
                           FrmGratPoint.LblLatit.Visible := false;
                           FrmGratPoint.RGGratType.Visible := true;
                           end;
    ord(cmBiquadraticPn),
   ord(cmConicConformal),
              ord(cmUTM),
         ord(cmEquiRect),
 ord(cmMillerCylindrical): begin
                           FrmGratPoint.NIOLat.Visible := true;
                           FrmGratPoint.LblLatit.Visible := true;
                           FrmGratPoint.LblLongLat.Caption := 'Longitude';
                           FrmGratPoint.RGGratType.Visible := false;
                           end;
  end;
  if FrmGratPoint.ShowModal = mrOK then
    begin
    case CBoxCalibModel.ItemIndex of
        ord(cmParabolicIp) : begin
                             GM.AddCalibPoint (TGratLineKind(FrmGratPoint.RGGratType.ItemIndex),
                                               FrmGratPoint.NIOVal.Value,
                                               GM.LastClickPosX, GM.LastClickPosY);
                             end;
      ord(cmBiquadraticPn),
     ord(cmConicConformal),
           ord(cmEquiRect),
   ord(cmMillerCylindrical): begin
                             GM.AddCalibPoint (FrmGratPoint.NIOLat.Value, FrmGratPoint.NIOVal.Value,
                                               GM.LastClickPosX, GM.LastClickPosY);
                             end;
                 ord(cmUTM): begin
                             GM.AddCalibPoint (FrmGratPoint.NIOLat.Value, FrmGratPoint.NIOVal.Value,
                                               FrmGratPoint.NIOUTMZone.IntegerValue,
                                               THemisphere(FrmGratPoint.RGHemisphere.Itemindex),
                                               GM.LastClickPosX, GM.LastClickPosY);
                             end;
    end;
    BButStoreMap.Enabled := true;
    end;
  end;
if SBRemoveCalib.Down then
  begin
  GM.RemoveCalibPoint (GM.LastClickPosX, GM.LastClickPosY);
  BButStoreMap.Enabled := true;
  SBOops.Enabled := true;
  end;
if SBAddLandmark.Down then
  begin
  long := 0;
  lat := GM.CalcLatitude (GM.LastClickPosX,GM.LastClickPosY,valid);
  if valid then
    long := GM.CalcLongitude (GM.LastClickPosX,GM.LastClickPosY,valid);
  if valid then
    begin
    GM.AddLandMark (Lat, Long, 0, TLandMarkElement(RGLMType.Itemindex), 
                    0, 'TEST', Now, 0,
                    CSelForegnd.SelColor, CSelBackGnd.SelColor,
                    SBarSize.Position, CBoxTransp.Checked,
                    SBarANgle.Position, SBarHead.Position);
    end;
  end;
if SBRemoveLM.Down then
  begin
  long := 0;
  lat := GM.CalcLatitude (GM.LastClickPosX,GM.LastClickPosY,valid);
  if valid then
    long := GM.CalcLongitude (GM.LastClickPosX,GM.LastClickPosY,valid);
  if valid then
    GM.RemoveLandMark(lat, long, -1);
  if GM.NumLandMarks = 0 then
    SBRemoveLM.Down := false;
  end;
end;

(******************************************************************************)
procedure TFrmMap.RGShowGratClick(Sender: TObject);
(******************************************************************************)

begin
GM.ShowGraticule := TShowGrat(RGShowGrat.ItemIndex);
end;

(******************************************************************************)
procedure TFrmMap.ButStoreMapClick(Sender: TObject);
(******************************************************************************)

begin
SaveDialog1.Filter := 'Calibrated Maps|*.xml';
if SaveDialog1.Execute then
  GM.SaveCalDataAsXML (StripExtension(SaveDialog1.Filename)+'.xml', 'myDataID');
end;

(******************************************************************************)
procedure TFrmMap.ButLoadMapClick(Sender: TObject);
(******************************************************************************)

begin
OpenDialog1.Filter := 'Calibrated Maps|*.xml';
if OpenDialog1.Execute then
  begin
  GM.LoadCalDataFromXML (OpenDialog1.FileName, '');
  CBoxCalibModel.ItemIndex := ord(GM.CalibModel);
  BButClearMap.Enabled := true;
  BButLoadLM.Enabled := true;
  BButSaveLM.Enabled := true;
  SBAddLandMark.Enabled := true;
  SBAddCalib.Enabled := true;
  SBRemoveCalib.Enabled := true;
  RGShowGrat.Enabled := true;
  SBMoveCalibPoint.Enabled := true;
  end;
end;


(******************************************************************************)
procedure TFrmMap.SBAddLandmarkClick(Sender: TObject);
(******************************************************************************)

begin
SBRemoveLM.Enabled := true;
end;

(******************************************************************************)
procedure TFrmMap.BButClearMapClick(Sender: TObject);
(******************************************************************************)

begin
GM.Clear;
SBRemoveLM.Enabled := false;
SBAddLandmark.Enabled := false;
SBRemoveCalib.Enabled := false;
SBAddCalib.Enabled := false;
BButStoreMap.Enabled := false;
end;

(******************************************************************************)
procedure TFrmMap.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TFrmMap.SBAddCalibClick(Sender: TObject);
(******************************************************************************)

begin
if SBAddCalib.Down
  then begin
       GM.Cursor := crCross;
       RGShowGrat.ItemIndex := ord(sgPointsAndLines);
       end
  else GM.Cursor := crDefault;
end;

(******************************************************************************)
procedure TFrmMap.SBRemoveCalibClick(Sender: TObject);
(******************************************************************************)

begin
GM.Cursor := crDefault;
end;

(******************************************************************************)
procedure TFrmMap.RGLMTypeClick(Sender: TObject);
(******************************************************************************)

var
  ena : boolean;

begin
if (RGLMType.ItemIndex = 4) or (RGLMType.ItemIndex = 5)
  then ena := true
  else ena := false;
SBarHead.Enabled := ena;
NLabHeadSize.Enabled := ena;
if RGLMType.ItemIndex = 2 then
  ena := true;
SBarAngle.Enabled := ena;
NLabAngle.Enabled := ena;
end;

(******************************************************************************)
procedure TFrmMap.SBarSizeChange(Sender: TObject);
(******************************************************************************)

begin
NLabLMSize.Value := SBarSize.Position;
end;

(******************************************************************************)
procedure TFrmMap.SBarHeadChange(Sender: TObject);
(******************************************************************************)

begin
NLabHeadSize.Value := SBarHead.Position;
end;

(******************************************************************************)
procedure TFrmMap.SBarAngleChange(Sender: TObject);
(******************************************************************************)

begin
NLabAngle.Value := SbarAngle.Position;
end;

(******************************************************************************)
procedure TFrmMap.BButSaveLMClick(Sender: TObject);
(******************************************************************************)

begin
SaveDialog1.Filter := 'Landmark Data|*.xml';
if SaveDialog1.Execute then
  GM.SaveLandmarks(StripExtension(SaveDialog1.FileName)+'.xml', '');
end;


(******************************************************************************)
procedure TFrmMap.BButLoadLMClick(Sender: TObject);
(******************************************************************************)

begin
OpenDialog1.Filter := 'Landmark Data|*.xml';
if OpenDialog1.Execute then
  GM.LoadLandmarks(OpenDialog1.FileName, '');
end;

(******************************************************************************)
procedure TFrmMap.CBoxCalibModelChange(Sender: TObject);
(******************************************************************************)

begin
GM.CalibModel := TCalibModel(CBoxCalibModel.ItemIndex);
end;

(******************************************************************************)
procedure TFrmMap.SBOopsClick(Sender: TObject);
(******************************************************************************)

begin
GM.RestoreLastDeletedCalPoint;
SBOops.Enabled := false;
end;

(******************************************************************************)
procedure TFrmMap.SBMoveCalibPointClick(Sender: TObject);
(******************************************************************************)

begin
if SBMoveCalibPoint.Down then
  begin
  CBoxMouseAct.ItemIndex := 0;
  GM.MouseAction := maNone;
  BButStoreMap.Enabled := true;
  end;
end;

(******************************************************************************)
procedure TFrmMap.Exit1Click(Sender: TObject);
(******************************************************************************)

begin
close;
end;


(******************************************************************************)
procedure TFrmMap.SBZoomOutClick(Sender: TObject);
(******************************************************************************)

var
  APoint : TPoint;

begin
APoint := GM.ControlToMapImage (Point(GM.width div 2, GM.height div 2));
GM.SuppressPaint := true;
GM.Magnification := GM.Magnification / sqrt(uc_sqrt2);
GM.BringMapPixelToCenter (APoint);
GM.SuppressPaint := false;
NLabMag.Value := GM.Magnification;
end;

(******************************************************************************)
procedure TFrmMap.SBZoomInClick(Sender: TObject);
(******************************************************************************)

var
  APoint : TPoint;

begin
APoint := GM.ControlToMapImage (Point(GM.width div 2, GM.height div 2));
GM.SuppressPaint := true;
GM.Magnification := GM.Magnification * sqrt(uc_sqrt2);
GM.BringMapPixelToCenter (APoint);
GM.SuppressPaint := false;
NLabMag.Value := GM.Magnification;
end;

(******************************************************************************)
procedure TFrmMap.CBoxMouseActChange(Sender: TObject);
(******************************************************************************)

begin
GM.MouseAction := TMouseActMode(CBoxMouseAct.ItemIndex);
end;

(******************************************************************************)
procedure TFrmMap.GMZoomPan(Sender: TObject);
(******************************************************************************)

begin
NLabMag.Value := GM.Magnification;
end;

(******************************************************************************)
procedure TFrmMap.NLabMagClick(Sender: TObject);
(******************************************************************************)

var
  APoint : TPoint;

begin
APoint := GM.ControlToMapImage (Point(GM.width div 2, GM.height div 2));
GM.SuppressPaint := true;
GM.Magnification := 1;
GM.BringMapPixelToCenter (APoint);
GM.SuppressPaint := false;
NLabMag.Value := 1.0;
end;


(******************************************************************************)
procedure TFrmMap.NIOUTMZoneChange(Sender: TObject);
(******************************************************************************)

begin
GM.UTMZone := NIOUTMZone.IntegerValue;
GM.UTMHemisphere := THemisphere(RGHemisph.ItemIndex);
end;

end.
