unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SDL_sdlbase, SDL_rchart, Menus, ExtCtrls, SDL_NumLab,
  SDL_Colsel;

type
  TForm1 = class(TForm)
    PopMenSc: TPopupMenu;
    Panel1: TPanel;
    Panel2: TPanel;
    CopyToClipboard1: TMenuItem;
    MySc: TSmithChart;
    NLabX: TNumLab;
    NLabY: TNumLab;
    NLabR: TNumLab;
    NLabImag: TNumLab;
    ButRemoveItem: TButton;
    SBarZoom: TScrollBar;
    ButAddLabel: TButton;
    EdLabel: TEdit;
    RGMouse: TRadioGroup;
    ButZoom11: TButton;
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    procedure Zoom1Click(Sender: TObject);
    procedure Pan1Click(Sender: TObject);
    procedure CopyToClipboard1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MyScCrossHairMove(Sender: TObject;
      WhichCrossHair: TCrossHair);
    procedure ButRemoveItemClick(Sender: TObject);
    procedure DragCrosshair1Click(Sender: TObject);
    procedure DragText1Click(Sender: TObject);
    procedure SBarZoomChange(Sender: TObject);
    procedure MyScDataRendered(Sender: TObject; canvas: Tcanvas; Top,
      Left: Integer);
    procedure ButAddLabelClick(Sender: TObject);
    procedure RGMouseClick(Sender: TObject);
    procedure ButZoom11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  printers, SDL_univconst, SDL_stringl;

const
  NumData = 27;
  Data : array[1..NumData, 1..3] of double =
             // Frequency     db(S11)      phi(S11)
              ((1.000e+04, -5.376e+00, 3.139),
               (1.584e+05, -5.380e+00, 3.102),
               (3.981e+05, -5.397e+00, 3.042),
               (6.309e+05, -5.429e+00, 2.983),
               (7.943e+05, -5.459e+00, 2.942),
               (1.000e+06, -5.509e+00, 2.889),
               (1.258e+06, -5.588e+00, 2.821),
               (1.584e+06, -5.716e+00, 2.733),
               (1.995e+06, -5.924e+00, 2.615),
               (2.511e+06, -6.269e+00, 2.456),
               (3.162e+06, -6.849e+00, 2.228),
               (3.981e+06, -7.810e+00, 1.878),
               (5.011e+06, -9.168e+00, 1.290),
               (6.309e+06, -9.512e+00, 0.324),
               (7.943e+06, -7.000e+00, -0.70),
               (1.000e+07, -4.443e+00, -1.42),
               (1.258e+07, -3.064e+00, -1.89),
               (1.584e+07, -2.416e+00, -2.21),
               (1.995e+07, -2.106e+00, -2.44),
               (2.511e+07, -1.948e+00, -2.60),
               (3.162e+07, -1.863e+00, -2.72),
               (3.981e+07, -1.815e+00, -2.81),
               (6.309e+07, -1.770e+00, -2.93),
               (8.912e+07, -1.756e+00, -2.99),
               (1.778e+08, -1.746e+00, -3.06),
               (4.466e+08, -1.743e+00, -3.11),
               (1.000e+09, -1.743e+00, -3.12));


(******************************************************************************)
procedure TForm1.Zoom1Click(Sender: TObject);
(******************************************************************************)

begin
MySc.MouseAction := maZoomDrag;
end;

(******************************************************************************)
procedure TForm1.Pan1Click(Sender: TObject);
(******************************************************************************)

begin
MySc.MouseAction := maPan;
end;

(******************************************************************************)
procedure TForm1.CopyToClipboard1Click(Sender: TObject);
(******************************************************************************)

begin
MySc.CopyToClipboard(false);
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

var
  i   : integer;
  mag : double;

begin
MySc.CrossHair.Mode := chBoth;
MySc.PopupMenu := PopMenSc;

MySc.TextAlignment := taLeftJustify;
for i:=1 to NumData do
  begin
  mag := exp(uc_ln10*Data[i,2]/20);
  MySc.DataColor := clRed;
  MySc.MarkAt(mag*cos(Data[i,3]), mag*sin(Data[i,3]), 24);
  if i mod 5 = 0 then
    begin
    MySc.DataColor := clMaroon;
    MySc.Text(mag*cos(Data[i,3]), mag*sin(Data[i,3]), 8, ' ----'+strff(Data[i,1]/1e6,1,2)+'MHz');
    end;
  end;
end;


(******************************************************************************)
procedure TForm1.MyScCrossHairMove(Sender: TObject;
  WhichCrossHair: TCrossHair);
(******************************************************************************)

begin
NLabX.Value :=WhichCrossHair.PosX;
NLabY.Value :=WhichCrossHair.PosY;
NLabImag.Value := MySC.CalcReactance(WhichCrossHair.PosX, WhichCrossHair.PosY);
NLabR.Value := MySC.CalcResistance(WhichCrossHair.PosX, WhichCrossHair.PosY);
end;


(******************************************************************************)
procedure TForm1.ButRemoveItemClick(Sender: TObject);
(******************************************************************************)

begin
MySc.RemoveLastItem;
MySc.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.DragCrosshair1Click(Sender: TObject);
(******************************************************************************)

begin
MySC.MouseAction := maDragCrossH;
end;

(******************************************************************************)
procedure TForm1.DragText1Click(Sender: TObject);
(******************************************************************************)

begin
MySC.MouseAction := maDragLabel;
end;


(******************************************************************************)
procedure TForm1.SBarZoomChange(Sender: TObject);
(******************************************************************************)

var
  cx, cy : double;
  hgt    : double;

begin
cx := (MySc.RangeXLow + MySc.RangeXHigh)/2;
cy := (MySc.RangeYLow + MySc.RangeYHigh)/2;
Hgt := SBarZoom.Position/100*(MySc.Height-MySc.MarginTop-MySc.MarginBottom+1)/(MySc.Width-MySc.MarginLeft-MySc.MarginRight+1);
MySc.SetRange (cx-SBarZoom.Position/100, cy-hgt,
               cx+SBarZoom.Position/100, cy+hgt);
end;

(******************************************************************************)
procedure TForm1.MyScDataRendered(Sender: TObject; canvas: Tcanvas;
  Top, Left: Integer);
(******************************************************************************)

var
  xout,yout: longint;

begin
Canvas.Brush.Color := clMoneyGreen;
canvas.Font.Color := clBlue;
Canvas.TextOut (50,30,'Any text drawn in the OnDataRendered event');
MySC.R2M (0.4, 0.8, xout,yout);
Canvas.TextOut (xout-Left, yout-Top,'This text sticks to the chart');
end;

(******************************************************************************)
procedure TForm1.ButAddLabelClick(Sender: TObject);
(******************************************************************************)

var
  ix : integer;

begin
ix := MySc.AddTextLabel(0, 0, clBlue, EdLabel.Text, 0);
MySc.TextLabels[ix].Mode := tlBox;
MySc.TextLabels[ix].ColorBkg := clYellow;
MySc.TextLabels[ix].PosX := -0.5;
end;


(******************************************************************************)
procedure TForm1.RGMouseClick(Sender: TObject);
(******************************************************************************)

begin
case RGMouse.ItemIndex of
  0 : MySc.MouseAction := maZoomWindPos;
  1 : MySc.MouseAction := maPan;
  2 : MySc.MouseAction := maDragLabel;
  3 : MySc.MouseAction := maDragCrossH;
end;
end;

(******************************************************************************)
procedure TForm1.ButZoom11Click(Sender: TObject);
(******************************************************************************)

begin
MySc.SetRange(-1.1, -1.1, 1.1, 1.1);
MySc.CenterChart;
end;

end.



