unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SDL_gradfl, SDL_RotLab, SDL_Colsel, SDL_onoffbut;

type
  TForm1 = class(TForm)
    SBarAngle: TScrollBar;
    GradFill1: TGradFill;
    FontDialog1: TFontDialog;
    ButSelFont: TButton;
    MyRotLab: TRotLab;
    ComboBox1: TComboBox;
    Label1: TLabel;
    CBoxAlignment: TComboBox;
    Label2: TLabel;
    EdCaption: TEdit;
    CSelBakColor: TColSel;
    Label3: TLabel;
    OOButAutoCenter: TOnOffBut;
    OOButTransparent: TOnOffBut;
    LblFeedback: TLabel;
    OOButEnabled: TOnOffBut;
    OOButAntiAlias: TOnOffBut;
    Label4: TLabel;
    procedure SBarAngleChange(Sender: TObject);
    procedure OOButTransparentClick(Sender: TObject);
    procedure ButSelFontClick(Sender: TObject);
    procedure OOButEnabledClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure MyRotLabMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure OOButAntiAliasClick(Sender: TObject);
    procedure CBoxAlignmentChange(Sender: TObject);
    procedure EdCaptionChange(Sender: TObject);
    procedure CSelBakColorChange(Sender: TObject);
    procedure OOButAutoCenterClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_sdlbase;


(******************************************************************************)
procedure TForm1.SBarAngleChange(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.TextAngle := SBarAngle.Position;
end;

(******************************************************************************)
procedure TForm1.OOButTransparentClick(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.Transparent := OOButTransparent.OnOff;
end;

(******************************************************************************)
procedure TForm1.ButSelFontClick(Sender: TObject);
(******************************************************************************)

begin
if FontDialog1.Execute then
  MyRotLab.Font := FontDialog1.Font;
end;

(******************************************************************************)
procedure TForm1.OOButEnabledClick(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.Enabled := OOButEnabled.OnOff;
LblFeedback.Enabled := OOButEnabled.OnOff;
end;

(******************************************************************************)
procedure TForm1.ComboBox1Change(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.FrameStyle := TFrameStyle(ComboBox1.ItemIndex);
end;

(******************************************************************************)
procedure TForm1.MyRotLabMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(******************************************************************************)

begin
if ssLeft in Shift then
  begin
  MyRotLab.PosX := X;
  MyRotLab.PosY := Y;
  end;
end;


(******************************************************************************)
procedure TForm1.OOButAntiAliasClick(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.AntiAlias := not OOButAntiAlias.OnOff;
end;

(******************************************************************************)
procedure TForm1.CBoxAlignmentChange(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.Alignment := TAlignment(CBoxAlignment.ItemIndex);
end;

(******************************************************************************)
procedure TForm1.EdCaptionChange(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.Caption := EdCaption.Text;
end;

(******************************************************************************)
procedure TForm1.CSelBakColorChange(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.Color := CSelBakColor.SelColor;
end;

(******************************************************************************)
procedure TForm1.OOButAutoCenterClick(Sender: TObject);
(******************************************************************************)

begin
MyRotLab.AutoCenter := OOButAutoCenter.OnOff;
if OOButAutoCenter.OnOff
  then LblFeedback.Caption := 'The label is auto-centered'
  else LblFeedback.Caption := 'You can drag the label text with the mouse';
end;

end.
