unit Tstspeed;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, SDL_NumLab,
  SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    Panel1: TPanel;
    ButExit: TButton;
    ButStart: TButton;
    LblT1: TLabel;
    ScrollBar1: TScrollBar;
    NLabDatPoi: TNumLab;
    LblT2: TLabel;
    GroupBox1: TGroupBox;
    RBZoom: TRadioButton;
    RBPan: TRadioButton;
    Label1: TLabel;
    procedure ButStartClick(Sender: TObject);
    procedure ButExitClick(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure RBZoomClick(Sender: TObject);
    procedure RBPanClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  SDL_sdlbase, SDL_stringl;

const
  MaxNumData = 13;
  NumData : array[1..MaxNumData] of integer = (100,200,500,1000,2000,5000,10000,20000,50000,100000,200000,500000,1000000);

var
  SWTime : double;


(***************************************************************)
procedure TForm1.ButStartClick(Sender: TObject);
(***************************************************************)

var
  i       : integer;
  npoi    : integer;
  t1, t2  : real;


begin
SWTime := Time;
npoi := round(NLabDatPoi.value);
RChart1.ClearGraf;
RChart1.SetRange (1, 0,-5,npoi,5);
Rchart1.Datacolor := clRed;
RChart1.Moveto (0,0);
for i:=1 to npoi do
  Rchart1.DrawTo (i,random+2000/(400+i)*sin(0.01*i));
t1 := 86400.0*(Time-SWTime);
RChart1.ShowGraf;
t2 := 86400.0*(Time-SWTime);
LblT1.Caption := 'Time to draw internally: '+strff(t1,1,2)+ ' sec';
LblT2.Caption := 'Total drawing time: '+strff(t2,1,2)+' sec';
end;


(***************************************************************)
procedure TForm1.ButExitClick(Sender: TObject);
(***************************************************************)

begin
close;
end;

(***************************************************************)
procedure TForm1.ScrollBar1Change(Sender: TObject);
(***************************************************************)

begin
RChart1.ClearGraf;
NLabDatPoi.Value := NumData[Scrollbar1.Position];
RChart1.Scale1X.RangeHigh := NumData[Scrollbar1.Position];
RChart1.ShowGraf;
end;

(***************************************************************)
procedure TForm1.RBZoomClick(Sender: TObject);
(***************************************************************)

begin
RChart1.MouseAction := maZoomWindPos;
end;

(***************************************************************)
procedure TForm1.RBPanClick(Sender: TObject);
(***************************************************************)

begin
RChart1.MouseAction := maPan;
end;

end.
