(********************************************************************)
(*                                                                  *)
(*                                                                  *)
(*                          RcTextLabels                            *)
(*                                                                  *)
(*                          Version 1.0                             *)
(*                                                                  *)
(*     (C) 2000 H. Lohninger                          Aug-2000      *)
(*                 P.O.B 123                                        *)
(*                 A-1061 Vienna, Austria, Europe                   *)
(*                 http://www.lohninger.com/                        *)
(*                                                                  *)
(*     Last Update: Aug-10, 2000                                    *)
(*                                                                  *)
(*  The program "RcTextLabels" is a Delphi sample program to show   *)
(*  the usage of text labels in RChart                              *)
(*                                                                  *)
(********************************************************************)


unit urctxtlab;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, Buttons, ExtDlgs, Grids, SDL_Colsel, SDL_rchart;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    CBoxTransparent: TCheckBox;
    SBarX: TScrollBar;
    SBarY: TScrollBar;
    RGAlign: TRadioGroup;
    CheckBox2: TCheckBox;
    RChart1: TRChart;
    BButExit: TBitBtn;
    RGMouseAction: TRadioGroup;
    RGMode: TRadioGroup;
    LblShadow: TLabel;
    Bevel1: TBevel;
    Label1: TLabel;
    CSelBakGnd: TColSel;
    CSelTxt: TColSel;
    Label2: TLabel;
    ButPrint: TButton;
    PrintDialog1: TPrintDialog;
    procedure CBoxTransparentClick(Sender: TObject);
    procedure DragLabels1Click(Sender: TObject);
    procedure Pan1Click(Sender: TObject);
    procedure SBarXChange(Sender: TObject);
    procedure SBarYChange(Sender: TObject);
    procedure RGAlignClick(Sender: TObject);
    procedure Zoom1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure RGMouseActionClick(Sender: TObject);
    procedure RGModeClick(Sender: TObject);
    procedure CSelBakGndChange(Sender: TObject);
    procedure CSelTxtChange(Sender: TObject);
    procedure ButPrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  consts, SDL_sdlbase, printers;


(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

var
  i : integer;

begin
RChart1.ClearGraf;
RChart1.DataColor := clMaroon;      // draw some data just for fun
RChart1.MoveTo (0,0);
for i:=1 to 500 do
  begin
  RChart1.ClassDefault := i mod 3;
  RChart1.DrawTo (i/5, sin(0.1*i)+0.3*random);
  end;
RChart1.DataColor := clNavy;        // draw a plain text label
RChart1.Text (20,-1.3, 10, 'not a label!');

RChart1.TextLabels[1].Mode := tlBox;
RChart1.TextLabels[1].PosX := 50;
RChart1.TextLabels[1].PosY := -1.2;
RChart1.TextLabels[1].Caption := RChart1.TextLabels[1].Caption + '<- yellow is beautiful -> ';
RChart1.TextLabels[1].ColorBkg := clYellow;
RChart1.TextLabels[1].Visible := true;

RChart1.TextLabels[4].AttachToData := tlamNone;
RChart1.TextLabels[4].PosX := 440;
RChart1.TextLabels[4].PosY := 200;
RChart1.TextLabels[4].Mode := tlSimple;
RChart1.TextLabels[4].Caption := 'Label 4:'+#10+'Try to change the properties '+#10+
                                 'of the label by using the'+#10+'controls above.';
RChart1.TextLabels[4].Alignment := taRightJustify;
RChart1.TextLabels[4].Font.Color := clBlue;
RChart1.TextLabels[4].Visible := true;

i := RChart1.AddTextLabel (20, 0, clRed, 'Label added by '+#10+'method "AddTextLabel"', 0);
if i > 0 then
  RChart1.TextLabels[i].Alignment := taLeftJustify;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.CBoxTransparentClick(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].Transparent := CBoxTransparent.Checked;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.DragLabels1Click(Sender: TObject);
(******************************************************************************)

begin
RChart1.MouseAction := maDragLabel;
end;

(******************************************************************************)
procedure TForm1.Pan1Click(Sender: TObject);
(******************************************************************************)

begin
RChart1.MouseAction := maPan;
end;

(******************************************************************************)
procedure TForm1.SBarXChange(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].ShadowDx := SBarX.Position;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.SBarYChange(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].ShadowDy := SBarY.Position;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.RGAlignClick(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].AlignMent := TAlignment(RGAlign.Itemindex);
RChart1.ShowGraf;
end;


(******************************************************************************)
procedure TForm1.Zoom1Click(Sender: TObject);
(******************************************************************************)

begin
RChart1.MouseAction := maZoomDrag;
end;

(******************************************************************************)
procedure TForm1.CheckBox2Click(Sender: TObject);
(******************************************************************************
  remark: when changing the attach mode during run-time we have to convert the
          current label coordinates from screen to chart coordinates and vice versa;
          otherwise the label will most probably get "lost"
 ******************************************************************************)

var
  xout1, yout1 : double;
  xout2, yout2 : longint;

begin
if Checkbox2.Checked
  then RChart1.TextLabels[4].AttachToData := tlamBoth
  else RChart1.TextLabels[4].AttachToData := tlamNone;
if RChart1.TextLabels[4].AttachToData = tlamBoth
  then begin
       RChart1.M2R (1, round(RChart1.TextLabels[4].PosX), round(RChart1.TextLabels[4].PosY),
                    xout1, yout1);
       RChart1.TextLabels[4].PosX := xout1;
       RChart1.TextLabels[4].PosY := yout1;
       end
  else begin
       RChart1.R2M (1, RChart1.TextLabels[4].PosX, RChart1.TextLabels[4].PosY, xout2, yout2);
       RChart1.TextLabels[4].PosX := xout2;
       RChart1.TextLabels[4].PosY := yout2;
       end;
end;


(******************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TForm1.RGMouseActionClick(Sender: TObject);
(******************************************************************************)

begin
case RGMouseAction.ItemIndex of
  0 : begin
      RChart1.MouseAction := maPan;
      RChart1.Caption := 'click and drag to pan the data window';
      end;
  1 : begin
      RChart1.MouseAction := maZoomDrag;
      RChart1.Caption := 'click and drag to zoom the data window';
      end;
  2 : begin
      RChart1.MouseAction := maDragLabel;
      RChart1.Caption := 'click and drag to move a label';
      end;
end;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.RGModeClick(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].Mode := TTxtLblMode(RGMode.ItemIndex);
RChart1.ShowGraf;
if TTxtLblMode(RGMode.ItemIndex) = tlShadow
  then begin
       SBarX.Visible := true;
       SBarY.Visible := true;
       LblShadow.Visible := true;
       CBoxTransparent.Enabled := false;
       end
  else begin
       SBarX.Visible := false;
       SBarY.Visible := false;
       LblShadow.Visible := false;
       CBoxTransparent.Enabled := true;
       end;
end;

(******************************************************************************)
procedure TForm1.CSelBakGndChange(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].ColorBkg := CSelBakGnd.SelColor;
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TForm1.CSelTxtChange(Sender: TObject);
(******************************************************************************)

begin
RChart1.TextLabels[4].Font.Color := CSelTxt.SelColor;
RChart1.ShowGraf;
end;


(******************************************************************************)
procedure TForm1.ButPrintClick(Sender: TObject);
(******************************************************************************)

var
  x, y : integer;

begin
if PrintDialog1.Execute then
  begin
  Printer.BeginDoc;
  Printer.Canvas.TextOut (300,180,'This is some text');
  Printer.Canvas.TextOut (300,240,'Another text line');
  x := 100;
  y := 400;
  RChart1.CopyToOpenPrinter (x,y, 1.0, true);   { the first chart }
  Printer.Canvas.TextOut (300,y+50,'Yet another line of text');
  x := 10;
  y := y+180;
  RChart1.CopyToOpenPrinter (x,y, 0.4, true);  { the second chart }
  Printer.EndDoc;
  end;
end;

end.
