(********************************************************************)
(*                                                                  *)
(*                                                                  *)
(*                          R C S H A R E D                         *)
(*                                                                  *)
(*                          Version 1.0                             *)
(*                                                                  *)
(*     (C) 2000 H. Lohninger                          Apr-2000      *)
(*                 P.O.B 123                                        *)
(*                 A-1061 Vienna, Austria, Europe                   *)
(*                 http://www.lohninger.com/                        *)
(*                                                                  *)
(*     Last Update: Aug-17, 2000                                    *)
(*                                                                  *)
(*  The program RCSHARED a Delphi sample program to show how to     *)
(*  use shared RCHart data windows. More information on the RChart  *)
(*  component can be found at http://www.lohninger.com/rchart.html  *)
(*                                                                  *)
(********************************************************************)

unit ushared;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, SDL_sdlbase, StdCtrls, Buttons, SDL_rchart;

type
  TFrmShared = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    RChart2: TRChart;
    Splitter1: TSplitter;
    RChart3: TRChart;
    RChart1: TRChart;
    Exit: TBitBtn;
    SBNoise: TScrollBar;
    Label1: TLabel;
    procedure ExitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RChart2ZoomPan(Sender: TObject);
    procedure RChart1CrossHairMove(Sender: TObject;
      WhichCrossHair: TCrossHair);
    procedure RChart3ZoomPan(Sender: TObject);
    procedure SBNoiseChange(Sender: TObject);
  private
    procedure DrawData;
  public
    { Public declarations }
  end;

var
  FrmShared: TFrmShared;

implementation

{$R *.DFM}

const
  MaxData = 2000;

(******************************************************************************)
procedure TFrmShared.ExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TFrmShared.DrawData;
(******************************************************************************)

var
  i : integer;

begin
RChart1.ClearGraf;
RChart1.MoveTo (1, cos(0.041)*sin(0.03)+1/1000+SBNoise.Position*0.01*random);
for i:=2 to MaxData do
  RChart1.DrawTo (i, cos(i*0.041)*sin(i*0.03)+5*exp(-sqr(0.01*(i-500)))+
                     7*exp(-sqr(0.021*(i-1500)))+SBNoise.Position*0.01*random);
RChart1.ShowGraf;
end;

(******************************************************************************)
procedure TFrmShared.FormShow(Sender: TObject);
(******************************************************************************)


begin
RChart1.SetRange (1, 0,-2, MaxData, 10);
RChart2.UseDataOf := RChart1;
RChart3.UseDataOf := RChart1;
DrawData;
RChart1CrossHairMove (Sender, nil);
end;

(******************************************************************************)
procedure TFrmShared.RChart2ZoomPan(Sender: TObject);
(******************************************************************************)

begin
RChart1.CrossHair1.PosX := RChart2.Scale1X.RangeLow;
RChart1.CrossHair2.PosX := RChart2.Scale1X.RangeHigh;
end;

(******************************************************************************)
procedure TFrmShared.RChart1CrossHairMove(Sender: TObject;
  WhichCrossHair: TCrossHair);
(******************************************************************************)

begin
RChart2.Scale1X.RangeLow := RChart1.CrossHair1.PosX;
RChart2.Scale1X.RangeHigh := RChart1.CrossHair2.PosX;
RChart3.Scale1X.RangeLow := RChart1.CrossHair3.PosX;
RChart3.Scale1X.RangeHigh := RChart1.CrossHair4.PosX;
end;

(******************************************************************************)
procedure TFrmShared.RChart3ZoomPan(Sender: TObject);
(******************************************************************************)

begin
RChart1.CrossHair3.PosX := RChart3.Scale1X.RangeLow;
RChart1.CrossHair4.PosX := RChart3.Scale1X.RangeHigh;
end;


(******************************************************************************)
procedure TFrmShared.SBNoiseChange(Sender: TObject);
(******************************************************************************)

begin
DrawData;
end;

end.
