unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SDL_rchart, StdCtrls;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    SBarBotRim: TScrollBar;
    procedure RChart1ScalesRendered(Sender: TObject; Canvas: TCanvas;
      Top, Left: Integer);
    procedure FormShow(Sender: TObject);
    procedure SBarBotRimChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_sdlbase;

const
  Mark1 = 6;
  Mark2 = 9;


(******************************************************************************)
procedure TForm1.RChart1ScalesRendered(Sender: TObject;
  Canvas: TCanvas; Top, Left: Integer);
(******************************************************************************)

begin
Canvas.Font.Color := RChart1.Font.Color;
Canvas.Pen.Color := clRed;
Canvas.Brush.Color := RChart1.WindColor;
Canvas.TextOut (10, Top+RChart1.Height-RChart1.BRim+40, 'Legend:');
DrawMarkOnCanvas (Canvas, Mark1, 30, Top+RChart1.Height-RChart1.BRim+70);
Canvas.TextOut (40, Top+RChart1.Height-RChart1.BRim+62, 'This is the data of experiment 1');
Canvas.Pen.Color := clBlue;
DrawMarkOnCanvas (Canvas, Mark2, 30, Top+RChart1.Height-RChart1.BRim+90);
Canvas.TextOut (40, Top+RChart1.Height-RChart1.BRim+82, 'This is the data of experiment 2');
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

var
  i : integer;

begin
RChart1.ClearGraf;
RChart1.DataColor := clRed;
for i:=1 to 70 do
  RChart1.MarkAt (i, sin(0.1*i), Mark1);
RChart1.DataColor := clblue;
for i:=1 to 70 do
  RChart1.MarkAt (i, cos(0.21*i), Mark2);
RChart1.ShowGraf;
end;


procedure TForm1.SBarBotRimChange(Sender: TObject);
begin
RChart1.BRim := SBarBotRim.Position;
end;

end.
