//---------------------------------------------------------------------------
#pragma hdrstop

#include "zoomit.h"
#include "math.h"
#include "logwarn.h"
#include "stdlib.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;
const int NumVal = 300;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
int i;

RBZoomPanOff->Checked = true;
PnlHints->Caption = "Select from Zoom Mode box to use interactive zooming and panning";
RChart1->SetRange (1, 0,-60,NumVal,110);
RChart1->MoveTo (0,0);
for (i=1; i<=NumVal; i++)
  RChart1->DrawTo (i,i/10+i/30*sin(i*0.04)+0.1*(random(200)+random(200)));
RChart1->DataColor = clRed;
RChart1->MoveTo (0,5);
for (i=1; i<=NumVal; i++)
  RChart1->DrawTo (i,5+i/10*sin(i*0.05)*cos(i*0.04));
RChart1->DataColor = clBlue;
for (i=1; i<=NumVal; i++)
  if (fmod(i,4) == 0)
    {
    RChart1->MarkAt (i,i/5*cos(i*0.05),4);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::But14Click(TObject *Sender)
{
double MidX, MidY, rx, ry;

MidX = (RChart1->Scale1X->RangeHigh+RChart1->Scale1X->RangeLow)/2;
MidY = (RChart1->Scale1Y->RangeHigh+RChart1->Scale1Y->RangeLow)/2;
rx = (RChart1->Scale1X->RangeHigh-RChart1->Scale1X->RangeLow)/2.8;
ry = (RChart1->Scale1Y->RangeHigh-RChart1->Scale1Y->RangeLow)/2.8;
RChart1->SetRange (1, MidX-rx,MidY-ry,MidX+rx,MidY+ry);
RChart1->ShowGraf();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::But07Click(TObject *Sender)
{
double MidX, MidY, rx, ry;

MidX = (RChart1->Scale1X->RangeHigh+RChart1->Scale1X->RangeLow)/2;
MidY = (RChart1->Scale1Y->RangeHigh+RChart1->Scale1Y->RangeLow)/2;
rx = 1.4*(RChart1->Scale1X->RangeHigh-RChart1->Scale1X->RangeLow)/2;
ry = 1.4*(RChart1->Scale1Y->RangeHigh-RChart1->Scale1Y->RangeLow)/2;
RChart1->SetRange (1, MidX-rx,MidY-ry,MidX+rx,MidY+ry);
RChart1->ShowGraf();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBZoomPanOffClick(TObject *Sender)
{
RChart1->MouseAction = Sdl_sdlbase::maNone;
PnlHints->Caption = "Select from Zoom Mode box to use interactive zooming and panning";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBPanClick(TObject *Sender)
{
RChart1->MouseAction = maPan;
PnlHints->Caption = "maPan: Click and drag on graphics";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBZoomClick(TObject *Sender)
{
RChart1->MouseAction = maZoomDrag;
PnlHints->Caption = "maZoomDrag: Click and drag on graphics";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBZoomWindClick(TObject *Sender)
{
RChart1->MouseAction = maZoomWind;
PnlHints->Caption = "maZoomWind: Click on graphics area to define window corners";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBZoomWindPosClick(TObject *Sender)
{
RChart1->MouseAction = maZoomWindPos;
PnlHints->Caption = "maZoomWindPos: Click on graphics area to define window corners";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButNormClick(TObject *Sender)
{
RChart1->Scale1X->Logarithmic = false;
RChart1->Scale1Y->Logarithmic = false;
CBLogX->Checked = false;
CBLogY->Checked = false;
RChart1->SetRange (1, 0,-60,NumVal,110);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BBtDoneClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CBLogXClick(TObject *Sender)
{
if ((! CBLogX->Checked) && (RChart1->Scale1X->RangeLow <= 0))
  {
  LogWarnForm->ShowModal();
  CBLogX->Checked = false;
  }
else
  {
  RChart1->Scale1X->Logarithmic = CBLogX->Checked;
  CBLogX->Checked = RChart1->Scale1X->Logarithmic;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CBLogYClick(TObject *Sender)
{
if ((! CBLogY->Checked) && (RChart1->Scale1Y->RangeLow <= 0))
  {
  LogWarnForm->ShowModal();
  CBLogY->Checked = false;
  }
else
  {
  RChart1->Scale1Y->Logarithmic = CBLogY->Checked;
  CBLogY->Checked = RChart1->Scale1Y->Logarithmic;
  }
}
//---------------------------------------------------------------------------