//---------------------------------------------------------------------------
#pragma hdrstop

#include "frmMain.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;
const int FirstYear = 1970;
const int LastYear = 1980;
const double Exprts[LastYear-FirstYear+1] = {10,20,50,75,100,16,-27,-28,3,10,42};
const TColor Colors[LastYear-FirstYear+1] = {clWhite, clBlue, clLime,
                                             clYellow, clTeal, clWhite,
                                             clBlue, clLime, clYellow,
                                             clTeal, clRed};
bool Bar3DOn;
bool Stopped;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DisplayChart (double Hgt, int Depth, int Ang)
{
int i;

ExportChart->ClearGraf();
ExportChart->DataColor = clBlack;
if (Bar3DOn == true)
  {
  if (Ang > 90)               // adjust the order of display according to angle }
    {
    for (i=LastYear; i>=FirstYear; i--)
      {
      ExportChart->FillColor = Colors[i-FirstYear];
      ExportChart->Bar3D (i-0.4, 0, i+0.4, Hgt*Exprts[i-FirstYear], Depth, Ang);
      }
    }
  else
    {
    for (i=FirstYear; i<=LastYear; i++)
      {
      ExportChart->FillColor = Colors[i-FirstYear];
      ExportChart->Bar3D (i-0.4, 0, i+0.4, Hgt*Exprts[i-FirstYear], Depth, Ang);
      }
    }
  }
else
  {
  for (i=FirstYear; i<=LastYear; i++)
    {
    ExportChart->FillColor = Colors[i-FirstYear];
    ExportChart->Rectangle (i-0.4, 0, i+0.4, Hgt*Exprts[i-FirstYear]);
    }
  }
ExportChart->ShowGraf();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BButDoneClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormMouseMove(TObject *Sender, TShiftState Shift, int X,
        int Y)
{
Screen->Cursor = crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RB3DonClick(TObject *Sender)
{
Bar3DOn = true;
DisplayChart (0.02*(50-SBarHeight->Position), 100-SBarDepth->Position, SBarAngle->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
Stopped = false;
Bar3DOn = true;
DisplayChart (0.02*(50-SBarHeight->Position), 100-SBarDepth->Position, SBarAngle->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BButAutoClick(TObject *Sender)
{
int step;

Stopped = false;
BButStop->Enabled = true;
BButDone->Enabled = false;
BButAuto->Enabled = false;
ExportChart->Scale1X->ColorScale = clBlack;
ExportChart->DataColor = clSilver;
step = 1;
do
  {
  Application->ProcessMessages();
  if (SBarHeight->Position <= 0)
    {
    step = +1;
    }
  if (SBarHeight->Position >= 100)
    {
    step = -1;
    }
  SBarHeight->Position = SBarHeight->Position + step;
  DisplayChart (0.02*(50-SBarHeight->Position), 100-SBarDepth->Position, SBarAngle->Position);
  }
while (Stopped == false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BButStopClick(TObject *Sender)
{
Stopped = true;
BButAuto->Enabled = true;
BButStop->Enabled = false;
BButDone->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBarHeightChange(TObject *Sender)
{
DisplayChart (0.02*(50-SBarHeight->Position),
              100-SBarDepth->Position,
              SBarAngle->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBarDepthChange(TObject *Sender)
{
DisplayChart (0.02*(50-SBarHeight->Position),
              100-SBarDepth->Position,
              SBarAngle->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBarAngleChange(TObject *Sender)
{
DisplayChart (0.02*(50-SBarHeight->Position),
              100-SBarDepth->Position,
              SBarAngle->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBRectClick(TObject *Sender)
{
Bar3DOn = false;
DisplayChart (0.02*(50-SBarHeight->Position),
              100-SBarDepth->Position,
              SBarAngle->Position);
}
//---------------------------------------------------------------------------
