unit TwoWind;

{-------------------------------------------------------------------}
interface
{-------------------------------------------------------------------}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ColorGrd, ExtCtrls, StdCtrls, Buttons, SDL_rchart;

type
  TTwoWinForm = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    RChart1: TRChart;
    RChart2: TRChart;
    Button2: TButton;
    Bevel1: TBevel;
    Button3: TButton;
    Button4: TButton;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    jx      : integer;
    signi   : integer;
  public
    { Public declarations }
  end;

var
  TwoWinForm: TTwoWinForm;

{-------------------------------------------------------------------}
implementation
{-------------------------------------------------------------------}

{$R *.DFM}

(******************************************************************************)
procedure TTwoWinForm.Button1Click(Sender: TObject);
(******************************************************************************)

begin
RChart2.Scale1X.RangeLow := -3;
RChart2.Scale1X.RangeHigh := 3;
RChart2.Scale1Y.RangeLow := 0;
RChart2.Scale1Y.RangeHigh := 110;
Button1.Enabled := false;
Button2.Enabled := true;
Button3.Enabled := false;
jx := 1;
signi := 1;
Timer1.Enabled := true;
Button2.Enabled := true;
Button1.Enabled := false;
Button3.Enabled := true;
end;

(******************************************************************************)
procedure TTwoWinForm.Button2Click(Sender: TObject);
(******************************************************************************)

begin
Button2.Enabled := false;
Button1.Enabled := true;
Button3.Enabled := true;
Timer1.Enabled := false;
end;

(******************************************************************************)
procedure TTwoWinForm.Button3Click(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TTwoWinForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(******************************************************************************)

begin
Screen.Cursor := crDefault;
end;

(******************************************************************************)
procedure TTwoWinForm.Timer1Timer(Sender: TObject);
(******************************************************************************)

const
  MaxJ = 66;

var
  i : integer;

begin
RChart1.ClearGraf;                              { window 1 }
RCHart1.MarkAt (sin((jx)/9),sin((jx)/7),19);
RCHart1.MoveTo (sin((jx)/9),sin((jx)/7));
for i:=1 to 25 do
  begin
  RCHart1.DrawTo (sin((i+jx)/9),sin((i+jx)/7));
  RCHart1.MarkAt (sin((i+jx)/9),sin((i+jx)/7),19);
  end;
RChart1.ShowGraf;

RChart2.ClearGraf;                              { window 2 }
RChart2.MoveTo (0,0);
RChart2.DataColor := clblack;
for i:=1 to 50 do
  RCHart2.DrawTo (exp(i/150)*sin(i*jx/800),i);
RChart2.DataColor := clWhite;
for i:=51 to 100 do
  RCHart2.DrawTo (exp(i/150)*sin(i*jx/800),i);
RChart2.ShowGraf;

jx := jx+signi;
if jx > MaxJ then
  Signi := -1;
if jx < -MaxJ then
  Signi := +1;
end;

(******************************************************************************)
procedure TTwoWinForm.Button4Click(Sender: TObject);
(******************************************************************************)

begin
RChart1.CopyToClipBoard (false);
end;

end.
