unit control;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, SDL_Colsel;

type
  TFrmControl = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    RGDotSize: TRadioGroup;
    RGDotSpacing: TRadioGroup;
    RGScroll: TRadioGroup;
    RGScrollSpeed: TRadioGroup;
    RGScrollStep: TRadioGroup;
    CSelDotFg: TColSel;
    CSelDotBg: TColSel;
    CSelBg: TColSel;
    CBoxProportional: TCheckBox;
    RGFrameStyle: TRadioGroup;
    BButFont: TBitBtn;
    ComboBlockMode: TComboBox;
    EdText: TEdit;
    Label4: TLabel;
    RGPlaceHolder: TRadioGroup;
    BButCloseUI: TBitBtn;
    FontDialog1: TFontDialog;
    BButDefaultFont: TBitBtn;
    procedure RGDotSizeClick(Sender: TObject);
    procedure RGDotSpacingClick(Sender: TObject);
    procedure RGScrollClick(Sender: TObject);
    procedure RGScrollSpeedClick(Sender: TObject);
    procedure RGScrollStepClick(Sender: TObject);
    procedure CSelDotFgChange(Sender: TObject);
    procedure CSelDotBgChange(Sender: TObject);
    procedure CSelBgChange(Sender: TObject);
    procedure ComboBlockModeChange(Sender: TObject);
    procedure CBoxProportionalClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RGFrameStyleClick(Sender: TObject);
    procedure BButFontClick(Sender: TObject);
    procedure EdTextChange(Sender: TObject);
    procedure BButCloseUIClick(Sender: TObject);
    procedure BButDefaultFontClick(Sender: TObject);
  private
  public
    function FillPlaceholder (Instring: string): string;
  end;

var
  FrmControl: TFrmControl;

implementation

{$R *.dfm}

uses
  SDL_stringl, SDL_rasterlab, SDL_sdlbase, mainfrm;


(******************************************************************************)
function TFrmControl.FillPlaceholder (Instring: string): string;
(******************************************************************************)

var
  ix   : integer;
  astr : string;

begin
case RGPlaceHolder.ItemIndex of
  1 : astr := strff(100*frac(Now),1,4);
  2 : astr := FormatDateTime ('HH:NN:SS', Now);
  3 : astr := FormatDateTime ('YYYY-MMM-DD  HH:NN:SS', Now);
else astr := '';
end;
ix := pos ('<dat>', lowercase(Instring));
if (ix > 0) and (astr <> '') then
  begin
  delete (Instring, ix, 5);
  insert (astr,Instring, ix);
  end;
Result := Instring;
end;


(******************************************************************************)
procedure TFrmControl.RGDotSizeClick(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.DotSize := RGDotSize.ItemIndex+1;
end;

(******************************************************************************)
procedure TFrmControl.RGDotSpacingClick(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.DotSpacing := RGDotSpacing.ItemIndex;
end;


(******************************************************************************)
procedure TFrmControl.RGScrollClick(Sender: TObject);
(******************************************************************************)

begin
case RGScroll.ItemIndex of
  0 : begin
      FrmMain.RLab1.ScrollMode := rdsmOff;
      FrmMain.RLab1.PosX := 0;
      FrmMain.RLab1.PosY := 0;
      end;
  5 : begin
      FrmMain.RLab1.ScrollMode := rdsmOff;
      FrmMain.RLab1.Height := 100;
      end;
  else FrmMain.RLab1.ScrollMode := TRDScrollMode(RGScroll.ItemIndex)
end;
end;


(******************************************************************************)
procedure TFrmControl.RGScrollSpeedClick(Sender: TObject);
(******************************************************************************)

const
  SSpd : array[0..6] of integer = (10,20,50,100,200,500,1000);

begin
FrmMain.RLab1.ScrollInterval := SSpd[RGScrollSpeed.Itemindex];
end;


(******************************************************************************)
procedure TFrmControl.RGScrollStepClick(Sender: TObject);
(******************************************************************************)

const
  SInc : array[0..6] of integer = (1,2,3,5,7,24,35);

begin
FrmMain.RLab1.ScrollIncrement := SInc[RGScrollStep.Itemindex];
end;


(******************************************************************************)
procedure TFrmControl.CSelDotFgChange(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.ColorDotOn := CSelDotFg.SelColor;
end;


(******************************************************************************)
procedure TFrmControl.CSelDotBgChange(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.ColorDotOff := CSelDotBg.SelColor;
end;


(******************************************************************************)
procedure TFrmControl.CSelBgChange(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.ColorLabBakG := CSelBg.SelColor;
end;


(******************************************************************************)
procedure TFrmControl.CBoxProportionalClick(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.Proportional := CBoxProportional.Checked;
end;


(******************************************************************************)
procedure TFrmControl.FormShow(Sender: TObject);
(******************************************************************************)

begin
CSelBg.SetAllColorEditFlags;
CSelDotFg.SetAllColorEditFlags;
CSelDotBg.SetAllColorEditFlags;
end;


(******************************************************************************)
procedure TFrmControl.RGFrameStyleClick(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.Framestyle := TFrameStyle(RGFrameStyle.ItemIndex);
end;

(******************************************************************************)
procedure TFrmControl.BButFontClick(Sender: TObject);
(******************************************************************************)

begin
if FontDialog1.Execute then
  FrmMain.RLab1.Font := FontDialog1.Font;
end;

(******************************************************************************)
procedure TFrmControl.ComboBlockModeChange(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.CharBlockMode := TRDBlockMode(ComboBlockMode.ItemIndex);
end;

(******************************************************************************)
procedure TFrmControl.EdTextChange(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.Text := FillPlaceHolder (EdText.Text);
end;


(******************************************************************************)
procedure TFrmControl.BButCloseUIClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;


(******************************************************************************)
procedure TFrmControl.BButDefaultFontClick(Sender: TObject);
(******************************************************************************)

begin
FrmMain.RLab1.Font.Name := 'default';
end;

end.
