unit Pcmain;

{--------------------------------------------------------------------------}
interface
{--------------------------------------------------------------------------}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, SDL_NumLab,
  SDL_rchart;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Timer1: TTimer;
    BButStop: TBitBtn;
    BButStart: TBitBtn;
    BButExit: TBitBtn;
    BButContinue: TBitBtn;
    Panel2: TPanel;
    NLabMouseX: TNumLab;
    NLabMouseY: TNumLab;
    NLabCh1: TNumLab;
    NLabCh2: TNumLab;
    NLabCh3: TNumLab;
    NLabCh4: TNumLab;
    RChart1: TRChart;
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BButStopClick(Sender: TObject);
    procedure BButStartClick(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure BButContinueClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

{--------------------------------------------------------------------------}
implementation
{--------------------------------------------------------------------------}

{$R *.DFM}

const
  NrChannels = 4;                                { number of data channels }
  PastTime = 120;                                { length of history trace }
  FutureTime = 20;                      { empty future space on time scale }

type
  DVecType = array[0..NrChannels] of double;      { array of data channels }
                                                 { channel 0 is time stamp }

var
  LastDataVec   : DVecType;               { recent values of data channels }
  StartDTime    : TDateTime;          { date and time of acquisition start }
  StopDTime     : TDateTime;           { date and time of acquisition stop }
  NumLabels     : array[1..NrCHannels] of TNumLab; { array of numeric labels }


(**************************************************************************)
function GetDataVector: DVecType;
(**************************************************************************
  This function aquires the data for all channels + the timestamp. The user
  should replace the generation of artificial data by his/her data sources.
 **************************************************************************)

var
  AuxVec : DVecType;

begin
AuxVec[0] := 86400*(Now-StartDTime);
// AuxVec[1] := 90-int(AuxVec[0]/10);
AuxVec[2] := 60+20*cos(AuxVec[0]*0.2)/ln(AuxVec[0]+2);
AuxVec[3] := 0.4*(random-0.5);
AuxVec[1] := Form1.NLabMouseY.Value;
AuxVec[4] := 110 + 150*cos(AuxVec[0]*0.21)*sin(AuxVec[0]*0.13)+70*sqr(sin(AuxVec[0]*0.37));
GetDataVector := AuxVec;
end;

(**************************************************************************)
procedure TForm1.Timer1Timer(Sender: TObject);
(**************************************************************************
  This timer routine is the central source of the data acquisition clock. At
  each clock tick, this routine aquires the latest data samples together with
  the absolute time. The data are then plotted against the passed time.
 **************************************************************************)

var
  OldDataVec  : DVecType;
  i           : integer;


begin
with RChart1 do
  begin
  SuppressPaint := true;
  OldDataVec := LastDataVec;          { backup the previous data samples }
  LastDataVec := GetDataVector;                    { get the new samples }
  for i:=1 to NrChannels do                      { draw the channel data }
    begin
    RChart1.ActiveLayer := i;
    DataColor := NumLabels[i].ColorLabBakG;
    Line (OldDataVec[0],OldDataVec[i],LastDataVec[0],LastDataVec[i]);
    NumLabels[i].Value := LastDataVec[i];
    end;
  if LastDataVec[0] > PastTime then
    begin               { start to scroll window after the initial phase }
    for i:=1 to NrChannels do
      begin
      RemoveFirstItem;   { remove all graphics items not needed any more }
      SetRange (i, LastDataVec[0]-PastTime, ScalePropsY[i].RangeLow,  { adjust range of chart }
                   LastDataVec[0]+FutureTime,ScalePropsY[i].RangeHigh);
      end;
    end;
  ActiveLayer := 1;
  SuppressPaint := false;                      { display the updated chart }
  end;
end;

(**************************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(**************************************************************************
  Initialize the main form.
 **************************************************************************)

var
  i : integer;

begin
NumLabels[1] := NLabCh1;   { this is only a dummy assignment in order to }
NumLabels[2] := NLabCh2;  { to simplify the access to the numeric labels }
NumLabels[3] := NLabCh3;
NumLabels[4] := NLabCh4;
for i:=1 to NrChannels do
  begin
  RChart1.ScalePropsX[i].RangeHigh := PastTime+FutureTime;
  RChart1.MouseAffectsLayer[i] := true;
  end;
end;

(**************************************************************************)
procedure TForm1.BButStopClick(Sender: TObject);
(**************************************************************************)

begin
StopDTime := Now;
Timer1.Enabled := false;
BButStart.Enabled := true;
BButContinue.Enabled := true;
BButStop.Enabled := false;
end;

(**************************************************************************)
procedure TForm1.BButStartClick(Sender: TObject);
(**************************************************************************)

var
  i : integer;

begin
for i:=1 to NrChannels do
  begin
  RChart1.ScalePropsX[i].RangeHigh := PastTime+FutureTime;
  RChart1.ScalePropsX[i].RangeLow := 0;
  end;
RChart1.ClearGraf;
StartDTime := Now;
LastDataVec := GetDataVector;
Timer1.Enabled := true;
BButStart.Enabled := false;
BButStop.Enabled := true;
end;

(**************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(**************************************************************************)

begin
close;
end;

(**************************************************************************)
procedure TForm1.BButContinueClick(Sender: TObject);
(**************************************************************************)

begin
StartDTime := StartDTime+(now-StopDTime);
LastDataVec := GetDataVector;
Timer1.Enabled := true;
BButStart.Enabled := false;
BButStop.Enabled := true;
BButContinue.Enabled := false;
end;



(**************************************************************************)
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(**************************************************************************)

begin
Screen.Cursor := crDefault;
end;

(**************************************************************************)
procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(**************************************************************************)

begin
Screen.Cursor := crDefault;
end;


(**************************************************************************)
procedure TForm1.RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(**************************************************************************)

begin
NLabMouseX.Empty := not InChart;
NLabMouseX.Value := rMousePosX;
NLabMouseY.Empty := not InChart;
NLabMouseY.Value := rMousePosY;
end;

end.



