//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "pcmain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SDL_NumLab"
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
*DVecType __fastcall GetDataVector()
/*
  This function aquires the data for all channels + the timestamp. The user
  should replace the generation of artificial data by his/her data sources.
*/
{
DVecType AuxVec;

AuxVec[0] = 86400*(Now-StartDTime);
AuxVec[1] = 90-int(AuxVec[0]/10);
AuxVec[2] = 60+20*cos(AuxVec[0]*0.2)/ln(AuxVec[0]+2);
AuxVec[3] = 0.4*(random-0.5);
AuxVec[4] = 110 + 150*cos(AuxVec[0]*0.21)*sin(AuxVec[0]*0.13)+70*sqr(sin(AuxVec[0]*0.37));
GetDataVector = AuxVec;
end;
}
//---------------------------------------------------------------------------


/*
(**************************************************************************)
procedure TForm1.Timer1Timer(Sender: TObject);
(**************************************************************************
  This timer routine is the central source of the data acquisition clock. At
  each clock tick, this routine aquires the latest data samples together with
  the absolute time. The data are then plotted against the passed time.
 **************************************************************************)


(**************************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(**************************************************************************
  Initialize the main form.
 **************************************************************************)

var
  i : integer;

begin
NumLabels[1] = NLabCh1;   { this is only a dummy assignment in order to }
NumLabels[2] = NLabCh2;  { to simplify the access to the numeric labels }
NumLabels[3] = NLabCh3;
NumLabels[4] = NLabCh4;
for i=1 to NrChannels do
  RChart1->ScalePropsX[i]->RangeHigh = PastTime+FutureTime;
end;

(**************************************************************************)
procedure TForm1.BButStopClick(Sender: TObject);
(**************************************************************************)

begin
StopDTime = Now;
Timer1->Enabled = false;
BButStart->Enabled = true;
BButContinue->Enabled = true;
BButStop->Enabled = false;
end;

(**************************************************************************)
procedure TForm1.BButStartClick(Sender: TObject);
(**************************************************************************)

var
  i : integer;

begin
for i=1 to NrChannels do
  begin
  RChart1->ScalePropsX[i]->RangeHigh = PastTime+FutureTime;
  RChart1->ScalePropsX[i]->RangeLow = 0;
  end;
RChart1->ClearGraf;
StartDTime = Now;
LastDataVec = GetDataVector;
Timer1->Enabled = true;
BButStart->Enabled = false;
BButStop->Enabled = true;
end;

(**************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(**************************************************************************)

begin
close;
end;

(**************************************************************************)
procedure TForm1.BButContinueClick(Sender: TObject);
(**************************************************************************)

begin
StartDTime = StartDTime+(now-StopDTime);
LastDataVec = GetDataVector;
Timer1->Enabled = true;
BButStart->Enabled = false;
BButStop->Enabled = true;
BButContinue->Enabled = false;
end;



(**************************************************************************)
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(**************************************************************************)

begin
Screen->Cursor = crDefault;
end;

(**************************************************************************)
procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(**************************************************************************)

begin
Screen->Cursor = crDefault;
end;


(**************************************************************************)
procedure TForm1.RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(**************************************************************************)

begin
NLabMouseX->Empty = not InChart;
NLabMouseX->Value = rMousePosX;
NLabMouseY->Empty = not InChart;
NLabMouseY->Value = rMousePosY;
end;

*/
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
DVecType  OldDataVec;
int       i;

RChart1->SuppressPaint = true;
OldDataVec = LastDataVec;                  // backup the previous data samples
LastDataVec = GetDataVector;                            // get the new samples
for i=1 to NrChannels do                              // draw the channel data
  begin
  RChart1->ActiveLayer = i;
  RChart1->DataColor = NumLabels[i]->ColorLabBakG;
  RChart1->Line (OldDataVec[0],OldDataVec[i],LastDataVec[0],LastDataVec[i]);
  NumLabels[i]->Value = LastDataVec[i];
  end;
if LastDataVec[0] > PastTime then
  begin               { start to scroll window after the initial phase }
  for i=1 to NrChannels do
    begin
    RChart1->RemoveFirstItem;   { remove all graphics items not needed any more }
    RChart1->SetRange (i, LastDataVec[0]-PastTime, ScalePropsY[i]->RangeLow,  { adjust range of chart }
                          LastDataVec[0]+FutureTime,ScalePropsY[i]->RangeHigh);
    end;
  end;
RChart1->ActiveLayer = 1;
RChart1->SuppressPaint = false;                      { display the updated chart }
end;

}
//---------------------------------------------------------------------------
