unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, SDL_geomap;

type
  TForm1 = class(TForm)
    GM1: TGeoMap;
    Panel1: TPanel;
    Timer1: TTimer;
    SBDriveCar: TSpeedButton;
    CBoxCarImage: TCheckBox;
    CBoxCenterCar: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure GM1DataRendered(Sender: TObject; const Canvas: TCanvas);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SBDriveCarClick(Sender: TObject);
    procedure CBoxCarImageClick(Sender: TObject);
    procedure CBoxCenterCarClick(Sender: TObject);
  private
    CarPosIx   : integer;
    CarImg     : TBitMap;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
{$R CARS.RES}

const
  MaxRtCoords = 102;
  RouteCoords : array[1..MaxRtCoords, 1..2] of double =
   ((47.815, 13.060), (47.852, 13.139), (47.848, 13.206), (47.836, 13.292), (47.864, 13.347),
    (47.848, 13.396), (47.836, 13.438), (47.872, 13.457), (47.905, 13.475), (47.930, 13.524),
    (47.954, 13.561), (47.946, 13.616), (47.950, 13.665), (47.954, 13.721), (47.970, 13.764),
    (47.995, 13.813), (48.015, 13.856), (48.011, 13.905), (48.023, 13.954), (48.051, 13.997),
    (48.063, 14.046), (48.034, 14.071), (47.997, 14.101), (47.964, 14.112), (47.927, 14.099),
    (47.894, 14.129), (47.861, 14.135), (47.836, 14.159), (47.799, 14.164), (47.774, 14.182),
    (47.749, 14.218), (47.737, 14.255), (47.720, 14.303), (47.679, 14.308), (47.641, 14.326),
    (47.613, 14.319), (47.584, 14.312), (47.564, 14.282), (47.539, 14.281), (47.526, 14.317),
    (47.514, 14.353), (47.505, 14.408), (47.492, 14.456), (47.479, 14.498), (47.475, 14.546),
    (47.470, 14.582), (47.457, 14.643), (47.448, 14.679), (47.435, 14.715), (47.422, 14.756),
    (47.413, 14.811), (47.401, 14.840), (47.396, 14.889), (47.399, 14.937), (47.382, 14.973),
    (47.365, 15.002), (47.348, 15.020), (47.360, 15.057), (47.380, 15.100), (47.383, 15.148),
    (47.395, 15.197), (47.407, 15.240), (47.423, 15.264), (47.451, 15.290), (47.471, 15.339),
    (47.499, 15.388), (47.518, 15.450), (47.529, 15.493), (47.545, 15.542), (47.565, 15.591),
    (47.584, 15.635), (47.604, 15.666), (47.607, 15.715), (47.615, 15.751), (47.626, 15.801),
    (47.638, 15.831), (47.653, 15.881), (47.661, 15.912), (47.676, 15.961), (47.696, 16.005),
    (47.719, 16.061), (47.731, 16.092), (47.726, 16.116), (47.737, 16.153), (47.761, 16.179),
    (47.781, 16.198), (47.810, 16.224), (47.835, 16.195), (47.876, 16.197), (47.913, 16.224),
    (47.942, 16.219), (47.970, 16.251), (47.985, 16.295), (48.013, 16.327), (48.042, 16.341),
    (48.071, 16.343), (48.099, 16.339), (48.132, 16.334), (48.156, 16.354), (48.179, 16.380),
    (48.199, 16.412), (48.223, 16.426));



(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

begin
GM1.LoadCalDataFromXML ('austria.xml', '');
GM1.TopLeft := Point(630,150);
end;


(******************************************************************************)
procedure TForm1.GM1DataRendered(Sender: TObject; const Canvas: TCanvas);
(******************************************************************************)

var
  x,y  : integer;

begin
if GM1.CalcPixelCoords (RouteCoords[CarPosIx,1], RouteCoords[CarPosIx,2], x, y) then
  begin
  if CBoxCarImage.Checked
    then begin
         Canvas.CopyMode := cmMergeCopy;
         Canvas.Draw(x-GM1.TopLeft.X, y-GM1.TopLeft.Y, CarImg);
         end
    else begin
         Canvas.Pen.Color := clLime;
         Canvas.Pen.Width := 3;
         Canvas.MoveTo(x-10-GM1.TopLeft.X,y-10-GM1.TopLeft.Y);
         Canvas.LineTo(x+10-GM1.TopLeft.X,y+10-GM1.TopLeft.Y);
         Canvas.MoveTo(x-10-GM1.TopLeft.X,y+10-GM1.TopLeft.Y);
         Canvas.LineTo(x+10-GM1.TopLeft.X,y-10-GM1.TopLeft.Y);
         end;
  end;
end;

(******************************************************************************)
procedure TForm1.Timer1Timer(Sender: TObject);
(******************************************************************************)

begin
inc (CarPosIx);
if CarPosIx > MaxRtCoords then
  CarPosIx := 1;
if CBoxCenterCar.Checked
  then GM1.BringLocationToCenter (RouteCoords[CarPosIx,1], RouteCoords[CarPosIx,2])
  else GM1.TopLeft := GM1.TopLeft;
end;


(******************************************************************************)
procedure TForm1.FormCreate(Sender: TObject);
(******************************************************************************)

begin
CarImg := TBitMap.Create;
CarImg.LoadFromResourceName (HInstance,'CARIMG1');
CarPosIx := 1;
end;

(******************************************************************************)
procedure TForm1.FormDestroy(Sender: TObject);
(******************************************************************************)

begin
CarImg.Free;
end;

(******************************************************************************)
procedure TForm1.SBDriveCarClick(Sender: TObject);
(******************************************************************************)

begin
Timer1.Enabled := SBDriveCar.Down;
end;

(******************************************************************************)
procedure TForm1.CBoxCarImageClick(Sender: TObject);
(******************************************************************************)

begin
GM1.TopLeft := GM1.TopLeft;
end;

(******************************************************************************)
procedure TForm1.CBoxCenterCarClick(Sender: TObject);
(******************************************************************************)

begin
GM1.BringLocationToCenter (RouteCoords[CarPosIx,1], RouteCoords[CarPosIx,2])
end;

end.
