unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, SDL_Meter;

type
  TForm1 = class(TForm)
    Meter1: TMeter;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CBoxLayout: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    LblDescription: TLabel;
    procedure Meter1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Meter1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Meter1MouseMoveInMeter(Sender: TObject; WithinRange: Boolean;
      Shift: TShiftState; MeterValue: Double);
    procedure CBoxLayoutChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

(******************************************************************************)
procedure TForm1.Meter1DragDrop(Sender, Source: TObject; X, Y: Integer);
(******************************************************************************)

begin
if Source is TLabel then
  Meter1.Value := StrToInt((Source as TLabel).Caption);
end;

(******************************************************************************)
procedure TForm1.Meter1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
(******************************************************************************)

begin
if Source is TLabel then
  Accept := true;
end;

(******************************************************************************)
procedure TForm1.Meter1MouseMoveInMeter(Sender: TObject;
  WithinRange: Boolean; Shift: TShiftState; MeterValue: Double);
(******************************************************************************)

begin
if WithinRange and (ssRight in Shift) then
  Meter1.Value := MeterValue;
end;

(******************************************************************************)
procedure TForm1.CBoxLayoutChange(Sender: TObject);
(******************************************************************************)

begin
Meter1.MeterLayout := TMeterLayout(CBoxLayout.ItemIndex);
end;

end.
