unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SDL_gauge, StdCtrls, ExtCtrls, SDL_NumLab, SDL_Colsel, SDL_Scale;

type
  TForm1 = class(TForm)
    SBarValue: TScrollBar;
    NLabGaugeCoord: TNumLab;
    CBoxIdxMode: TComboBox;
    CBoxScaleFixed: TCheckBox;
    SGauge1: TScaleGauge;
    SGauge2: TScaleGauge;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    ComboBox1: TComboBox;
    CSelBg1: TColSel;
    CSelBg2: TColSel;
    GroupBox2: TGroupBox;
    SBarMarginLeft: TScrollBar;
    SBarMarginRight: TScrollBar;
    SBarMarginTop: TScrollBar;
    SBarMarginBottom: TScrollBar;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    GroupBox3: TGroupBox;
    CBoxFrStyleInner: TComboBox;
    CBoxFrStyleOuter: TComboBox;
    GroupBox4: TGroupBox;
    CSelColorCover: TColSel;
    GroupBox5: TGroupBox;
    CSelIdx1: TColSel;
    CSelIdx2: TColSel;
    procedure ComboBox1Change(Sender: TObject);
    procedure SBarValueChange(Sender: TObject);
    procedure Gauge1MouseMoveInGauge(Sender: TObject; InGauge: Boolean;
                 Shift: TShiftState; rMousePos: Double);
    procedure CBoxIdxModeChange(Sender: TObject);
    procedure CSelIdx1Change(Sender: TObject);
    procedure CSelIdx2Change(Sender: TObject);
    procedure CSelBg1Change(Sender: TObject);
    procedure CSelBg2Change(Sender: TObject);
    procedure CBoxFrStyleOuterChange(Sender: TObject);
    procedure CBoxFrStyleInnerChange(Sender: TObject);
    procedure CBoxScaleFixedClick(Sender: TObject);
    procedure CSelColorCoverChange(Sender: TObject);
    procedure SBarMarginLeftChange(Sender: TObject);
    procedure SBarMarginRightChange(Sender: TObject);
    procedure SBarMarginTopChange(Sender: TObject);
    procedure SBarMarginBottomChange(Sender: TObject);
    procedure SGauge1MouseMoveInGauge(Sender: TObject; InGauge: Boolean;
      Shift: TShiftState; rMousePos: Double);
    procedure FormShow(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_sdlbase;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
SGauge1.Background := TGaugeBackground(ComboBox1.ItemIndex);
end;

procedure TForm1.SBarValueChange(Sender: TObject);
begin
SGauge1.Value := SBarValue.Position/10;
SGauge2.Value := SBarValue.Position/10;
end;


procedure TForm1.Gauge1MouseMoveInGauge(Sender: TObject; InGauge: Boolean;
  Shift: TShiftState; rMousePos: Double);
begin
if InGauge
  then NLabGaugeCoord.ColorLabBakG := clGreen
  else NLabGaugeCoord.ColorLabBakG := clRed;
NLabGaugeCoord.Value := rMousePos;
end;

procedure TForm1.CBoxIdxModeChange(Sender: TObject);
begin
SGauge1.IndexMode := TGaugeIndexMode(CBoxIdxMode.ItemIndex);
end;

procedure TForm1.CSelIdx1Change(Sender: TObject);
begin
SGauge1.ColorIndex1 := CSelIdx1.SelColor;
end;

procedure TForm1.CSelIdx2Change(Sender: TObject);
begin
SGauge1.ColorIndex2 := CSelIdx2.SelColor;
end;

procedure TForm1.CSelBg1Change(Sender: TObject);
begin
SGauge1.ColorBg1 := CSelBg1.SelColor;
end;

procedure TForm1.CSelBg2Change(Sender: TObject);
begin
SGauge1.ColorBg2 := CSelBG2.SelColor;
end;

procedure TForm1.CBoxFrStyleOuterChange(Sender: TObject);
begin
SGauge1.FrameStyleOuter := TFrameStyle(CBoxFrStyleOuter.ItemIndex);
end;

procedure TForm1.CBoxFrStyleInnerChange(Sender: TObject);
begin
SGauge1.FrameStyleInner := TFrameStyle(CBoxFrStyleInner.ItemIndex);
end;

procedure TForm1.CBoxScaleFixedClick(Sender: TObject);
begin
SGauge1.FixedDial := CBoxScaleFixed.Checked;
end;

procedure TForm1.CSelColorCoverChange(Sender: TObject);
begin
SGauge1.ColorCover := CSelColorCover.SelColor;
end;

procedure TForm1.SBarMarginLeftChange(Sender: TObject);
begin
SGauge1.MarginLeft := SBarMarginLeft.Position;
end;

procedure TForm1.SBarMarginRightChange(Sender: TObject);
begin
SGauge1.MarginRight := SBarMarginRight.Position;
end;

procedure TForm1.SBarMarginTopChange(Sender: TObject);
begin
SGauge1.MarginTop := SBarMarginTop.Position;
end;

procedure TForm1.SBarMarginBottomChange(Sender: TObject);
begin
SGauge1.MarginBottom := SBarMarginBottom.Position;
end;


(*************************************************************************************)
procedure TForm1.SGauge1MouseMoveInGauge(Sender: TObject; InGauge: Boolean;
  Shift: TShiftState; rMousePos: Double);
(*************************************************************************************)

begin
if InGauge
  then NLabGaugeCoord.ColorLabBakG := clLime
  else NLabGaugeCoord.ColorLabBakG := $6080FF;
NLabGaugeCoord.Value := rMousePos;
end;

(*************************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(*************************************************************************************)

begin
if SDL_gauge.IsLightEd
  then Width := 386
  else begin
       Width := 450;
       SGauge2.Orientation := goVertical;
       SGauge2.Visible := true;
       end;
end;

end.                                            ^
