unit ufilter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Menus, SDL_fourier, SDL_rchart;


type
  TFrmFilter = class(TForm)
    RCSignal: TRChart;
    RCFFT: TRChart;
    RCFilt: TRChart;
    FFT1: TFastFourier;
    SBFreqLimit: TScrollBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Label1: TLabel;
    procedure RadioButton1Click(Sender: TObject);
    procedure SBFreqLimitChange(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure CalcSignals;
  public
    { Public declarations }
  end;

var
  FrmFilter: TFrmFilter;

implementation

{$R *.DFM}

(************************************************************************)
procedure TFrmFilter.CalcSignals;
(************************************************************************)

var
  i : integer;
  y : double;

begin
RCFilt.ClearGraf;
RCFFT.ClearGraf;
RCSignal.ClearGraf;
RCSignal.DataColor := clBlue;
for i:=1 to FFT1.SpectrumSize do
  begin
  y := 3*sin(0.12*i)+1.6*cos(0.071*i)+4*(random-0.5);
  FFT1.RealSpec[i] := y;
  if i < 500  then
    RCSignal.DrawTo (i,y);
  end;
FFT1.Transform;
RCFFT.DataColor := clRed;
RCFFT.MoveTo (0,0);
for i:=1 to SBFreqLimit.Position do
  RCFFT.DrawTo (i, FFT1.Magnitude[i]);
RCSignal.ShowGraf;
RCFFT.ShowGraf;
for i:=SBFreqLimit.Position+1 to FFT1.SpectrumSize-SBFreqLimit.Position+1 do
  begin  // set both positive and negative frequencies to zero
  FFT1.ImagSpec[i] := 0;
  FFT1.RealSpec[i] := 0;
  end;
FFT1.InverseTransform;
RCFilt.DataColor := clBlue;
RCFilt.ClearGraf;
for i:=1 to (FFT1.SpectrumSize div 2) do
  RCFilt.DrawTo (i, FFT1.RealSpec[i]);
RCFilt.ShowGraf;
end;


(************************************************************************)
procedure TFrmFilter.RadioButton1Click(Sender: TObject);
(************************************************************************)

begin
CalcSignals;
end;

(************************************************************************)
procedure TFrmFilter.SBFreqLimitChange(Sender: TObject);
(************************************************************************)

begin
CalcSignals;
end;


(************************************************************************)
procedure TFrmFilter.Exit1Click(Sender: TObject);
(************************************************************************)

begin
close;
end;

(************************************************************************)
procedure TFrmFilter.FormShow(Sender: TObject);
(************************************************************************)

begin
CalcSignals;
end;

end.
