unit Frmcent;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, SDL_NumLab,
  SDL_rchart;


type
  TForm1 = class(TForm)
    Panel1: TPanel;
    RChart1: TRChart;
    BButExit: TBitBtn;
    BButCreateD: TBitBtn;
    BButCalcCent: TBitBtn;
    NLabProcCnt: TNumLab;
    BButkMeans: TBitBtn;
    procedure BButExitClick(Sender: TObject);
    procedure BButCreateDClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BButCalcCentClick(Sender: TObject);
    procedure BButkMeansClick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  SDL_sdlbase, SDL_math1, SDL_vector, SDL_matrix,  SDL_math2;

const
  NData = 300;                    { number of data points }
  NCenters = 10;                      { number of centers }
  Clut : array[1..NCenters] of TColor =
                         (clblack, clLime, clPurple, clYellow, clBlue,
                          $FF8844, $88FF44, $8844FF, $4488FF, $FF4488);

var
  Data     : TMatrix;                       { data matrix }
  Centers  : TMatrix;                { calculated centers }
  ClassVec : TIntVector;        { vector of class numbers }


(*********************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(*********************************************************)

begin
close;
end;

(*********************************************************)
procedure TForm1.BButCreateDClick(Sender: TObject);
(*********************************************************)

var
  i : integer;
  x,y : double;

begin
RChart1.ClearGraf;
RChart1.DataColor := clBlack;
for i:=1 to NData div 2 do
  begin
  repeat
    x := 0.05*RChart1.Scale1X.RangeHigh+0.9*RChart1.Scale1X.RangeHigh*random;
    y := 0.05*RChart1.Scale1Y.RangeHigh+0.9*RChart1.Scale1Y.RangeHigh*random;
  until (x < 40) or (y < 50);
  Data.Elem[1,i] := x;
  Data.Elem[2,i] := y;
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
for i:=NData div 2 to NData-60 do
  begin
  Data.Elem[1,i] := 0.15*RChart1.Scale1X.RangeHigh+0.1*RChart1.Scale1X.RangeHigh*random;
  Data.Elem[2,i] := 0.15*RChart1.Scale1Y.RangeHigh+0.1*RChart1.Scale1Y.RangeHigh*random;
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
for i:=NData-59 to NData-40 do
  begin
  Data.Elem[1,i] := 0.8*RChart1.Scale1X.RangeHigh+0.15*RChart1.Scale1X.RangeHigh*random;
  Data.Elem[2,i] := 0.85*RChart1.Scale1Y.RangeHigh+0.1*RChart1.Scale1Y.RangeHigh*random;
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
for i:=NData-39 to NData-20 do
  begin
  Data.Elem[1,i] := 0.25*RChart1.Scale1X.RangeHigh+0.1*RChart1.Scale1X.RangeHigh*random;
  Data.Elem[2,i] := 0.25*RChart1.Scale1Y.RangeHigh+0.1*RChart1.Scale1Y.RangeHigh*random;
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
for i:=NData-19 to NData do
  begin
  Data.Elem[1,i] := 0.5*RChart1.Scale1X.RangeHigh+0.15*RChart1.Scale1X.RangeHigh*random;
  Data.Elem[2,i] := 0.25*RChart1.Scale1Y.RangeHigh+0.1*RChart1.Scale1Y.RangeHigh*random;
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
RChart1.SHowGraf;
end;

(*********************************************************)
procedure TForm1.FormCreate(Sender: TObject);
(*********************************************************)

begin
Data := TMatrix.Create (nil);
Data.Resize(2,NData);
Data.Fill (0);
Centers := TMatrix.Create (nil);
Centers.Resize(2,NCenters);
Centers.Fill (0);
ClassVec := TIntVector.Create (nil);
ClassVec.Resize(NCenters);
ClassVec.Fill (0);
end;

(*********************************************************)
procedure ShowProgress (cnt: double); far;
(*********************************************************)

begin
Form1.NLabProcCnt.Value := 100*(cnt/NData);
end;

(*********************************************************)
procedure TForm1.BButCalcCentClick(Sender: TObject);
(*********************************************************)

var
  MeanDist : double;
  i        : integer;

begin
ProcStat := 0;
MathFeedbackProc := ShowProgress;
NLabProcCnt.LeftText := '... calculating';
NLabProcCnt.RightText := '% done';
NLabProcCnt.Visible := true;
FindCenters (Data, 1, Data.NrOfRows, NCenters, Centers, MeanDist);            { mean distance }
RChart1.ClearGraf;
RChart1.DataColor := clBlack;
for i:=1 to NData do
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
RChart1.DataColor := clRed;
for i:=1 to NCenters do
  RChart1.MarkAt (Centers.Elem[1,i],Centers.Elem[2,i],12);
RChart1.SHowGraf;
MathFeedbackProc := NIL;
NLabProcCnt.Visible := false;
end;


(*********************************************************)
procedure TForm1.BButkMeansClick(Sender: TObject);
(*********************************************************)

var
  MeanDist : double;
  i        : integer;

begin
ProcStat := 0;
MathFeedbackProc := ShowProgress;
NLabProcCnt.LeftText := '... calculating';
NLabProcCnt.RightText := '% done';
NLabProcCnt.Visible := true;
kMeansClustering (Data, 1, Data.NrOfRows, NCenters, Centers, ClassVec);
RChart1.ClearGraf;
for i:=1 to NData do
  begin
  RChart1.DataColor := Clut[ClassVec[i]];
  RChart1.MarkAt (Data.Elem[1,i],Data.Elem[2,i],7);
  end;
RChart1.DataColor := clRed;
for i:=1 to NCenters do
  RChart1.MarkAt (Centers.Elem[1,i],Centers.Elem[2,i],12);
RChart1.SHowGraf;
MathFeedbackProc := NIL;
NLabProcCnt.Visible := false;
end;

end.
