unit frmmain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SDL_rchart, SDL_Fourier, ExtCtrls;

type
  TForm1 = class(TForm)
    FFT1: TFastFourier;
    RC1: TRChart;
    ButAcquireSignal: TButton;
    RC2: TRChart;
    RGDispType: TRadioGroup;
    procedure ButAcquireSignalClick(Sender: TObject);
    procedure RGDispTypeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

(******************************************************************************)
procedure TForm1.ButAcquireSignalClick(Sender: TObject);
(******************************************************************************)

var
  j : integer;

begin
RC1.ClearGraf;
RC1.MoveTo(0,0);
for j:=1 to 187500 do
  RC1.DrawTo (j/187500, sin(2*pi*j/3125));
RC1.ShowGraf;
FFT1.ClearImag;
for j:=1 to FFT1.SpectrumSize do
  FFT1.RealSpec[j] := sin(2*pi*j/3125);
FFT1.Transform;
RGDispTypeClick(Sender);
end;

(******************************************************************************)
procedure TForm1.RGDispTypeClick(Sender: TObject);
(******************************************************************************)

var
  j : integer;

begin
RC2.ClearGraf;
RC2.Scale1Y.RangeHigh := 1.02*FFT1.MagniMax;
RC2.DataColor := clRed;
if RGDispType.ItemIndex = 0
  then begin
       RC2.Scale1X.Caption := 'Hz';
       RC2.Scale1X.RangeHigh := 100;
       for j:=1 to 50  do
         begin
         RC2.MoveTo (FFT1.FreqOfLine(j, 1/187500), 0);
         RC2.DrawTo (FFT1.FreqOfLine(j, 1/187500), FFT1.Magnitude[j])
         end;
       end
  else begin
       RC2.Scale1X.Caption := 'harmonics';
       RC2.Scale1X.RangeHigh := 40;
       for j:=1 to 40  do
         begin
         RC2.MoveTo (j, 0);
         RC2.DrawTo (j, FFT1.Magnitude[j]);
         end;
       end;
RC2.ShowGraf;
end;

end.
