unit frmfft;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls,
  SDL_fourier, SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    RChart2: TRChart;
    ScrollBar1: TScrollBar;
    SBFreq1: TScrollBar;
    Label1: TLabel;
    FFT1: TFastFourier;
    BButExit: TBitBtn;
    Label2: TLabel;
    CBoxWind: TComboBox;
    Label3: TLabel;
    RGSpecType: TRadioGroup;
    CBLogY: TCheckBox;
    procedure ScrollBar1Change(Sender: TObject);
    procedure SBFreq1Change(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CBoxWindChange(Sender: TObject);
    procedure RGSpecTypeClick(Sender: TObject);
    procedure CBLogYClick(Sender: TObject);
  private
    procedure StartFFT;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation


{$R *.DFM}


uses
  SDL_stringl;

const
  ChartYRanges : array[0..6,1..2] of double =
                    ((0,10),  { Magnitude }
                     (0,50000), { PowerSpec }
                     (-2,2), { Phase }
                     (-10,10), { FourSerCosCoeff }
                     (-10,10), { FourSerSinCoeff }
                     (-2000,2000),  { RealSpec }
                     (-2000,2000)); { ImagSpec }


(**************************************************************)
procedure TForm1.StartFFT;
(**************************************************************)


var
  i      : integer;
  y      : double;

begin
RChart1.ClearGraf;
RChart1.DataColor := clBlue;
RChart1.MoveTo (0,0);
FFT1.ClearImag;
for i:=1 to FFT1.SpectrumSize do
  begin
  y := 10*(sin(0.01*i*(100-SbFreq1.Position))+sin(0.075*i)+cos(0.5*i)+
       0.06*(random(100-ScrollBar1.Position)-0.5*(100-ScrollBar1.Position)));
  FFT1.RealSpec[i] := y;           { real value }
  RChart1.DrawTo (i,y);
  end;
RChart1.ShowGraf;

FFT1.Transform;

RChart2.ClearGraf;
RChart2.DataColor := clRed;
RChart2.MoveTo (FFT1.FreqOfLine(1,0.001),0);
y := 0;
for i:=1 to (FFT1.SpectrumSize div 2) do
  begin
  case RGSpecType.ItemIndex of
    0 : y := FFT1.Magnitude[i];
    1 : y := FFT1.PowerSpec[i];
    2 : y := FFT1.Phase[i];
    3 : y := FFT1.FourSerCosCoeff[i];
    4 : y := FFT1.FourSerSinCoeff[i];
    5 : y := FFT1.RealSpec[i+1];
    6 : y := FFT1.ImagSpec[i+1];
  end;
  RChart2.DrawTo (FFT1.FreqOfLine(i,0.001),y);
  end;
RChart2.ShowGraf;
end;

(**************************************************************)
procedure TForm1.ScrollBar1Change(Sender: TObject);
(**************************************************************)

begin
STartFFT;
end;

(**************************************************************)
procedure TForm1.SBFreq1Change(Sender: TObject);
(**************************************************************)

begin
StartFFT;
end;

(**************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(**************************************************************)

begin
close;
end;

(**************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(**************************************************************)

begin
CBoxWind.Text := 'None';
StartFFT;
end;


(**************************************************************)
procedure TForm1.CBoxWindChange(Sender: TObject);
(**************************************************************)

begin
FFT1.WeightingWindow := TFastFourierWgtWin(CBoxWind.ItemIndex);
StartFFT;
end;

(**************************************************************)
procedure TForm1.RGSpecTypeClick(Sender: TObject);
(**************************************************************)

begin
case RGSpecType.ItemIndex of
  0,1 : CBLogY.Enabled := true;
  2,3,4,5,6 : CBLogY.Enabled := false;
end;
RChart2.Scale1Y.RangeLow := ChartYRanges[RGSpecType.ItemIndex,1];
RChart2.Scale1Y.RangeHigh := ChartYRanges[RGSpecType.ItemIndex,2];
case RGSpecType.ItemIndex of
  0 : RChart2.Caption := 'Magnitude Spectrum';
  1 : rchart2.Caption := 'Power Spectrum';
  2 : rchart2.Caption := 'Phase Angle';
  3 : rchart2.Caption := 'Cosine Terms';
  4 : RChart2.Caption := 'Sine Terms';
  5 : RChart2.Caption := 'Real Part of Complex Spectrum';
  6 : RChart2.Caption := 'Imaginary Part of Complex Spectrum';
end;
StartFFT;
end;



(**************************************************************)
procedure TForm1.CBLogYClick(Sender: TObject);
(**************************************************************)

begin
if not CBLogY.Enabled
  then RChart2.Scale1Y.Logarithmic := false
  else if CBLogY.Checked
         then begin
              if RGSpecType.ItemIndex = 0
                then RChart2.Scale1Y.RangeLow := 1e-4
                else RChart2.Scale1Y.RangeLow := 1e-6;
              RChart2.Scale1Y.Logarithmic := true;
              end
         else RChart2.Scale1Y.Logarithmic := false;
StartFFT;
end;

end.




