unit ufdistri;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls,
  SDL_sdlbase, SDL_NumLab, SDL_rchart;

type
  TFrmFDistri = class(TForm)
    RChart1: TRChart;
    Panel1: TPanel;
    BButExit: TBitBtn;
    SBDf1: TScrollBar;
    SBDF2: TScrollBar;
    NLabDf1: TNumLab;
    NLabDF2: TNumLab;
    NLabCrosshair: TNumLab;
    NLabQuantile: TNumLab;
    procedure BButExitClick(Sender: TObject);
    procedure SBDf1Change(Sender: TObject);
    procedure SBDF2Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RChart1CrossHairMove(Sender: TObject;
      WhichCrossHair: TCrossHair);
  private
    procedure PlotDistribution (DF1, DF2: integer);
  public
    { Public declarations }
  end;

var
  FrmFDistri: TFrmFDistri;

implementation

{$R *.DFM}

uses
  SDL_statis;

const
  xRes = 500;   { resolution in x }

(***********************************************************)
procedure TFrmFDistri.PlotDistribution (DF1, DF2: integer);
(***********************************************************)

var
  i : integer;
  F : double;

begin
RChart1.ClearGraf;
RChart1.MoveTo (0,0);
for i:=1 to xRes do
  begin
  F := i*RChart1.Scale1X.RangeHigh/xRes;
  RChart1.DrawTo (F, FDistriDensity (F,df1,df2));
  end;
RChart1.ShowGraf;
NLabCrossHair.Value := FDistriDensity (RChart1.CrossHair1.PosX, df1, df2);
end;

(***********************************************************)
procedure TFrmFDistri.BButExitClick(Sender: TObject);
(***********************************************************)

begin
close;
end;


(***********************************************************)
procedure TFrmFDistri.SBDf1Change(Sender: TObject);
(***********************************************************)

begin
NLabDF1.Value := SBDF1.Position;
PlotDistribution (SBDF1.Position, SBDF2.Position);
end;

(***********************************************************)
procedure TFrmFDistri.SBDF2Change(Sender: TObject);
(***********************************************************)

begin
NLabDF2.Value := SBDF2.Position;
PlotDistribution (SBDF1.Position, SBDF2.Position);
end;

(***********************************************************)
procedure TFrmFDistri.FormShow(Sender: TObject);
(***********************************************************)

begin
PlotDistribution (SBDF1.Position, SBDF2.Position);
NLabCrossHair.Value := 1-FDistriIntegral (RChart1.CrossHair1.PosX, SBDF1.Position, SBDF2.Position);
NLabQuantile.Value := RChart1.CrossHair1.PosX;
end;

(***********************************************************)
procedure TFrmFDistri.RChart1CrossHairMove(Sender: TObject;
  WhichCrossHair: TCrossHair);
(***********************************************************)

begin
NLabCrossHair.Value := 1-FDistriIntegral (RChart1.CrossHair1.PosX, SBDF1.Position, SBDF2.Position);
NLabQuantile.Value := RChart1.CrossHair1.PosX;
end;

end.
