unit Rot3data;


{
a color choice for the bounding box:

      ColorChart:        $00FFF8E0
      ColorCubeFaceHigh: $00FCFCFF
      ColorCubeFaceLow:  $00EEEEFF
      ColorCubeFrame:    clMaroon
      ColorCubeHidLin:   $00DADADA
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Menus,
  SDL_NumLab, SDL_Rot3D;

type
  TForm1 = class(TForm)
    Rot3D1: TRot3D;
    NLabAlpha: TNumLab;
    SBAngX: TScrollBar;
    SBAngY: TScrollBar;
    NLabBeta: TNumLab;
    ScrollBar4: TScrollBar;
    NumLab4: TNumLab;
    BButExit: TBitBtn;
    RadioGroup1: TRadioGroup;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    CheckBox1: TCheckBox;
    SBBBSize: TScrollBar;
    SBAutoRot: TSpeedButton;
    SBAxSize: TScrollBar;
    PopupMenu1: TPopupMenu;
    Rotate1: TMenuItem;
    Zoom1: TMenuItem;
    Pan1: TMenuItem;
    SBAngZ: TScrollBar;
    NLabGamma: TNumLab;
    Label1: TLabel;
    Label2: TLabel;
    copy1: TMenuItem;
    ToClipboard1: TMenuItem;
    ToBMPFile1: TMenuItem;
    SaveDialog1: TSaveDialog;
    CBIsoMetric: TCheckBox;
    Info1: TMenuItem;
    ToClipBdWMF: TMenuItem;
    BButPrintit: TBitBtn;
    PrintDialog1: TPrintDialog;
    RGCoordSystem: TRadioGroup;
    CboxEvents: TCheckBox;
    procedure SBAngXChange(Sender: TObject);
    procedure SBAngYChange(Sender: TObject);
    procedure ScrollBar4Change(Sender: TObject);
    procedure Rot3D1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure BButExitClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SBBBSizeChange(Sender: TObject);
    procedure SBAutoRotClick(Sender: TObject);
    procedure SBAxSizeChange(Sender: TObject);
    procedure Rotate1Click(Sender: TObject);
    procedure Zoom1Click(Sender: TObject);
    procedure Pan1Click(Sender: TObject);
    procedure SBAngZChange(Sender: TObject);
    procedure ToClipboard1Click(Sender: TObject);
    procedure ToBMPFile1Click(Sender: TObject);
    procedure CBIsoMetricClick(Sender: TObject);
    procedure Rot3D1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Info1Click(Sender: TObject);
    procedure Rot3D1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure ToClipBdWMFClick(Sender: TObject);
    procedure BButPrintitClick(Sender: TObject);
    procedure RGCoordSystemClick(Sender: TObject);
    procedure CboxEventsClick(Sender: TObject);
    procedure Rot3D1DataRendered(Sender: TObject; Canvas: TCanvas);
  private
    procedure Rot3D1BeforeDataRender(Sender: TObject; Canvas: TCanvas);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  SDL_SDLBase, SDL_sdlcolors, uinfo;

{$R *.DFM}

var
  vax, vay        : double;
  dvax, dvay      : double;
  MousePosX,
  MousePosY       : integer;
  LastItemFound   : longint;
  LastFoundColor  : TColor;

(***************************************************************)
procedure TForm1.SBAngXChange(Sender: TObject);
(***************************************************************)

begin
Rot3D1.ViewAngleX := SBAngX.Position;
NLabAlpha.Value := SBAngX.Position;
end;

(***************************************************************)
procedure TForm1.SBAngYChange(Sender: TObject);
(***************************************************************)

begin
Rot3D1.ViewAngleY := SBAngY.Position;
NLabBeta.Value := SBAngY.Position;
end;

(***************************************************************)
procedure TForm1.SBAngZChange(Sender: TObject);
(***************************************************************)

begin
Rot3D1.ViewAngleZ := SBAngZ.Position;
NLabGamma.Value := SBAngZ.Position;
end;


(***************************************************************)
procedure TForm1.ScrollBar4Change(Sender: TObject);
(***************************************************************)

begin
Rot3D1.Magnification := 1-Scrollbar4.Position/100;
NumLab4.VAlue := Rot3D1.Magnification;
end;

(***************************************************************)
procedure TForm1.Rot3D1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(***************************************************************)


begin
MousePosX := X;
MousePosY := Y;
if ssLeft in Shift then
  begin
  vax := Rot3D1.ViewAngleX;
  vay := Rot3D1.ViewAngley;
  end;
end;

(***************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(***************************************************************)

begin
SBAutoRot.Down := false;
close;
end;

(***************************************************************)
procedure TForm1.RadioButton1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.BoundBoxStyle := bbNone;
end;

(***************************************************************)
procedure TForm1.RadioButton2Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.BoundBoxStyle := bbFrame;
end;

(***************************************************************)
procedure TForm1.RadioButton3Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.BoundBoxStyle := bbFaces;
end;

(***************************************************************)
procedure TForm1.CheckBox1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.ShowAxes := CheckBox1.Checked;
end;

(***************************************************************)
procedure TForm1.SBBBSizeChange(Sender: TObject);
(***************************************************************)

begin
Rot3D1.BoundBoxSize := SBBBSize.Position;
end;

(***************************************************************)
procedure TForm1.SBAutoRotClick(Sender: TObject);
(***************************************************************)


begin
dvax := 0.97;
dvay := 0.67;
while SBAutoRot.Down do
  begin
  Application.ProcessMessages;
  vax := vax + dvax;
  if vax > 360 then
    vax := vax-360;
  vay := vay + dvay;
  if vay > 360 then
    vay := vay - 360;
  Rot3D1.SetViewAngles (vax, vay, 90);
  end;
Rot3D1.SetViewAngles (SBAngX.Position, SBAngY.Position, SBAngZ.Position);
end;


(***************************************************************)
procedure TForm1.SBAxSizeChange(Sender: TObject);
(***************************************************************)

begin
Rot3D1.AxSize := SBAxSize.Position;
end;

(***************************************************************)
procedure TForm1.Rotate1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.MouseAction := maRotate;
end;

(***************************************************************)
procedure TForm1.Zoom1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.MouseAction := maZoom;
end;

(***************************************************************)
procedure TForm1.Pan1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.MouseAction := maPan;
end;

(***************************************************************)
procedure TForm1.ToClipboard1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.CopyToClipboard (false);
end;


(***************************************************************)
procedure TForm1.ToBMPFile1Click(Sender: TObject);
(***************************************************************)

begin
SaveDialog1.Filename := '*.bmp';
if SaveDialog1.Execute then
  Rot3D1.CopyToBMP (SaveDialog1.Filename, false);
end;

(***************************************************************)
procedure TForm1.CBIsoMetricClick(Sender: TObject);
(***************************************************************)

begin
Rot3D1.IsoMetric := CBIsoMetric.Checked;
end;

(***************************************************************)
procedure TForm1.Rot3D1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
(***************************************************************)

var
  ItemP : longint;
  ItPar : Tr3ChartItem;
  dist  : double;

begin
if (Rot3D1.MouseAction = maNone) and (ssLeft in Shift) then
  begin
  with Rot3D1 do
    begin
    ItemP := FindNearestItemScreen (X, Y, tkEveryThing, dist);
    if ItemP <> -1 then
      begin
      LastItemFound := ItemP;                  { mark found item red }
      Itpar := GetItemParams (Itemp);
      LastFoundColor := ItPar.Color;
      ItPar.Color := clRed;
      SetItemParams (ItemP, ItPar);
      MakeVisible;
      FrmInfo.Left := Form1.Left+X+30;{ display coords of found item }
      FrmInfo.Top := Form1.Top+Y+30;
      FrmInfo.NLXCoord.Value := ItPar.x;
      FrmInfo.NLYCoord.Value := ItPar.y;
      FrmInfo.NLZCoord.Value := ItPar.z;
      FrmInfo.Show;
      end;
    end;
  end;
end;


(***************************************************************)
procedure TForm1.Info1Click(Sender: TObject);
(***************************************************************)

begin
Rot3D1.MouseAction := maNone;
end;

(***************************************************************)
procedure TForm1.Rot3D1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
(***************************************************************)

var
  ItPar : Tr3ChartItem;

begin
if LastItemFound <> -1 then
  begin
  Itpar := Rot3D1.GetItemParams (LastItemFound);
  ItPar.Color := LastFoundColor;
  Rot3D1.SetItemParams (LastItemFound, ItPar);
  Rot3D1.MakeVisible;
  FrmInfo.Hide;
  end;
end;

(***************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(***************************************************************)

const
  NPOI = 10000;

var
  i : integer;
  rx, ry, rz : double;
  r,g,b      : integer;

begin
Rot3D1.Clear;
for i:=1 to NPOI do
  begin
  rx := i/10+20*random;
  ry := 0.1*(rx + 50*random);
  rz := 30*random+sqr(rx+ry)/1400;
  HSIToRGB (i/NPOI*360, 1, 1, r,g,b);
  Rot3D1.ColorData := RGB (r,g,b);
  Rot3D1.MarkAt (rx,ry,rz,16);
  end;
for i:=1 to NPOI do
  begin
  HSIToRGB (i/NPOI*30, i/NPOI, 1, r,g,b);
  Rot3D1.ColorData := RGB (r,g,b);
  Rot3D1.MarkAt (2+10*i/NPOI+4*random,10+50*i/NPOI+10*random,120+30*random,7);
  end;
Rot3D1.MakeVisible;
LastItemFound := -1;
Rot3D1.OnDataRendered := Rot3D1DataRendered;
Rot3D1.OnBeforeRenderData := Rot3D1BeforeDataRender;
end;


(***************************************************************)
procedure TForm1.ToClipBdWMFClick(Sender: TObject);
(***************************************************************)

begin
SaveDialog1.Filename := '*.wmf';
if SaveDialog1.Execute then
  Rot3D1.CopyToWMF (SaveDialog1.Filename, false);
end;


(***************************************************************)
procedure TForm1.BButPrintitClick(Sender: TObject);
(***************************************************************)

begin
if PrintDialog1.Execute then
  Rot3D1.Printit (1.0, false, false);
end;


(***************************************************************)
procedure TForm1.RGCoordSystemClick(Sender: TObject);
(***************************************************************)

begin
Rot3D1.AxDir := TAxDir(RGCoordSystem.ItemIndex);
end;


(***************************************************************)
procedure TForm1.Rot3D1BeforeDataRender(Sender: TObject; Canvas: TCanvas);
(***************************************************************)

begin
if CboxEvents.Checked then
  begin
  Canvas.Pen.Color := clBlack;
  Canvas.Brush.Color := $BBBBBB;
  Canvas.Rectangle (100,100, 250,250);
  Canvas.Font.Color := clNavy;
  Canvas.TextOut(108,106, 'Back Plane');
  end;
end;

(***************************************************************)
procedure TForm1.Rot3D1DataRendered(Sender: TObject; Canvas: TCanvas);
(***************************************************************)

begin
if CboxEvents.Checked then
  begin
  Canvas.Pen.Color := clBlack;
  Canvas.Brush.Color := $DDDDDD;
  Canvas.Rectangle (150,150,300,300);
  Canvas.Font.Color := clNavy;
  Canvas.TextOut(158,156, 'Top Plane');
  end;
end;


(***************************************************************)
procedure TForm1.CboxEventsClick(Sender: TObject);
(***************************************************************)

begin
Rot3D1.RePaint;
end;



end.


