unit Frmcfit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls,
  SDL_stringl, SDL_math2, SDL_NumLab, SDL_rchart;

type
  TFrmMain = class(TForm)
    RChart1: TRChart;
    Panel1: TPanel;
    SBNewPnts: TSpeedButton;
    NLabFitQual: TNumLab;
    Panel2: TPanel;
    BButParabolFit: TSpeedButton;
    BButCalcReciprLine: TSpeedButton;
    BButHyper: TSpeedButton;
    BButLogFit: TSpeedButton;
    BButGaussFit: TSpeedButton;
    BButLinFit: TSpeedButton;
    BButExit: TSpeedButton;
    SBClear: TSpeedButton;
    LblFormula: TLabel;
    LblParams: TLabel;
    BButPolynomial: TSpeedButton;
    SEPolyOrder: TSpinEdit;
    LblPolyOrder: TLabel;
    BButSpline: TSpeedButton;
    SBarSmoothSpline: TScrollBar;
    LblSmoothSpline: TLabel;
    Stats1: TCurveFit;
    BButCircle: TSpeedButton;
    SBPowerFit: TSpeedButton;
    SBExpo: TSpeedButton;
    SBHoerl: TSpeedButton;
    SBRecipLog: TSpeedButton;
    SBReciHyperbol: TSpeedButton;
    procedure BButExitClick(Sender: TObject);
    procedure RChart1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SBNewPntsClick(Sender: TObject);
    procedure BButParabolFitClick(Sender: TObject);
    procedure BButCalcReciprLineClick(Sender: TObject);
    procedure BButHyperClick(Sender: TObject);
    procedure BButLogFitClick(Sender: TObject);
    procedure BButGaussFitClick(Sender: TObject);
    procedure BButLinFitClick(Sender: TObject);
    procedure SBClearClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure BButPolynomialClick(Sender: TObject);
    procedure SEPolyOrderChange(Sender: TObject);
    procedure BButSplineClick(Sender: TObject);
    procedure SBarSmoothSplineChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure SBReciHyperbolClick(Sender: TObject);
    procedure SBRecipLogClick(Sender: TObject);
    procedure BButCircleClick(Sender: TObject);
    procedure SBPowerFitClick(Sender: TObject);
    procedure SBExpoClick(Sender: TObject);
    procedure SBHoerlClick(Sender: TObject);
  private
    procedure DisableElements;
    procedure ShowSpline;
  public
    { Public declarations }
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}

uses
  SDL_sdlbase;

const
  ChartXRes = 200;
  MSG_ONLYPAIDVERS = 'This regression model is available only with the paid version of the SDL Suite.';


(*****************************************************************)
procedure TFrmMain.DisableElements;
(*****************************************************************)

begin
SBarSmoothSpline.Enabled := false;
LblSmoothSpline.Enabled := false;
LblPolyOrder.Enabled := false;
SEPolyOrder.Enabled := false;
end;


(*****************************************************************)
procedure TFrmMain.BButCircleClick(Sender: TObject);
(*****************************************************************)

var
  r, dx, dy : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcCircleFit (r, dx, dy);
       NLabFitQual.Value := 0;
       NLabFitQual.Empty := true;
       RChart1.TransparentItems := true;
       RChart1.Ellipse(dx, dy, r, r);
       RChart1.MoveTo (dx-r/4, dy);
       RChart1.DrawTo (dx+r/4, dy);
       RChart1.MoveTo (dx, dy-r/4);
       RChart1.DrawTo (dx, dy+r/4);
       RChart1.ShowGraf;
       LblFormula.Caption := 'sqr(r) = sqr(x-dx) + sqr(y-dy)';
       LblParams.Caption := 'r = '+strff(r,1,3)+'    dx = '+strff(dx,1,3)+'    dy = '+strff(dy,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;


(*****************************************************************)
procedure TFrmMain.BButExitClick(Sender: TObject);
(*****************************************************************)

begin
close;
end;


(*****************************************************************)
procedure TFrmMain.SBClearClick(Sender: TObject);
(*****************************************************************)

begin
Stats1.Init;
RChart1.ClearGraf;
RChart1.ShowGraf;
SbNewPnts.Down := false;
LblFormula.Visible := false;
LblParams.Visible := true;
LblParams.Caption := '<---- click here to enter data';
DisableElements;
end;


(*****************************************************************)
procedure TFrmMain.SBExpoClick(Sender: TObject);
(*****************************************************************)

// y = k0 * e^(k1*x)

var
  k0, k1   : double;
  FitQUal  : double;
  xstep    : double;
  i        : integer;
  x        : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcExponentialFit (k0, k1, FitQual);
       NLabFitQual.Value := FitQual;
       NLabFitQual.Empty := false;
       RChart1.MoveTo (RChart1.Scale1X.RangeLow,k0*exp(k1*RChart1.Scale1X.RangeLow));
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         RChart1.DrawTo (x, k0*exp(k1*x));
         end;
       RChart1.ShowGraf;
       LblFormula.Caption := 'y = k0 + e^(k1*x)';
       LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;



(*****************************************************************)
procedure TFrmMain.SBHoerlClick(Sender: TObject);
(*****************************************************************)

// y = k0 * k1^x * x^k2

var
  k0, k1, k2 : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcHoerlFit (k0, k1, k2, FitQual);
       NLabFitQual.Value := FitQual;
       NLabFitQual.Empty := false;
       RChart1.MoveTo (RChart1.Scale1X.RangeLow, k0*exp(RChart1.Scale1X.RangeLow*ln(k1))*exp(k2*ln(RChart1.Scale1X.RangeLow)));
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         RChart1.DrawTo (x, k0*exp(x*ln(k1))*exp(k2*ln(x)));
         end;
       RChart1.ShowGraf;
       LblFormula.Caption := 'y = k0 * k1^x * x^k2';
       LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3)+'    k2 = '+strff(k2,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;



(*****************************************************************)
procedure TFrmMain.RChart1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
(*****************************************************************)

var
  rx, ry : double;

begin
if SBNewPnts.Down then
  begin
  RChart1.M2R (1, x,y, rx, ry);
  RChart1.MarkAt (rx,ry,26);
  Stats1.EnterStatValue (rx, ry);
  if Stats1.NumData <=9 then
    SEPolyOrder.MaxValue := Stats1.NumData-1;
  if SEPolyOrder.Value > SEPolyOrder.MaxValue then
    SEPolyOrder.Value := SEPolyOrder.MaxValue;
  RChart1.ShowGraf;
  end;
end;

(*****************************************************************)
procedure TFrmMain.SBNewPntsClick(Sender: TObject);
(*****************************************************************)

begin
DisableElements;
BButLinFit.Down := false;
BButParabolFit.Down := false;
BButPolynomial.Down := false;
BButCalcReciprLine.Down := false;
BButHyper.Down := false;
BButLogFit.Down := false;
BButGaussFit.Down := false;
BButSpline.Down := false;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
RChart1.ShowGraf;
LblFormula.Visible := false;
if not SBNewPnts.Down
  then LblParams.Caption := '<---- click here to enter data'
  else LblParams.Caption := 'click into chart to enter new data points';
LblParams.Visible := true;
end;

(*****************************************************************)
procedure TFrmMain.SBPowerFitClick(Sender: TObject);
(*****************************************************************)

// y = k0 * x^k1

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcPowerFit (k0, k1, FitQual);
       NLabFitQual.Value := FitQual;
       NLabFitQual.Empty := false;
       RChart1.MoveTo (RChart1.Scale1X.RangeLow,k0*exp(k1*ln(RChart1.Scale1X.RangeLow)));
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         RChart1.DrawTo (x, k0*exp(k1*ln(x)));
         end;
       RChart1.ShowGraf;
       LblFormula.Caption := 'y = k0 + x^k1';
       LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;


(*****************************************************************)
procedure TFrmMain.SBReciHyperbolClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x, denom   : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcReciHyperbolFit (k0, k1, FitQual);
       NLabFitQual.Value := FitQUal;
       NLabFitQual.Empty := false;
       if RChart1.Scale1X.RangeLow <> 0
         then RChart1.MoveTo (RChart1.Scale1X.RangeLow,RChart1.Scale1X.RangeLow/(k0+k1*RChart1.Scale1X.RangeLow))
         else RChart1.MoveTo (RChart1.Scale1X.RangeLow,0);
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         denom := k0*x +k1;
         if denom <> 0
           then RChart1.DrawTo (x,x/denom)
           else RChart1.DrawTo (x,1e6);
         end;
       RChart1.ShowGraf;
       LblFormula.Caption := 'y = x/(k0*x+k1)';
       LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;


(*****************************************************************)
procedure TFrmMain.SBRecipLogClick(Sender: TObject);
(*****************************************************************)

// y = 1/(k0+k1*ln(x))

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;
  denom      : double;

begin
if SDL_math2.IsLightEd
  then MessageDlg (MSG_ONLYPAIDVERS, mtInformation, [mbOK], 0)
  else begin
       DisableElements;
       while (RChart1.TypeOfLastItem <> tkMarkAt) and
             (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
         RChart1.RemoveLastItem;
       SbNewPnts.Down := false;
       Stats1.CalcReciLogFit (k0, k1, FitQual);
       NLabFitQual.Value := FitQUal;
       NLabFitQual.Empty := false;
       denom := k0+k1*ln(RChart1.Scale1X.RangeLow);
       if denom <> 0 then
         RChart1.MoveTo (RChart1.Scale1X.RangeLow,1/denom);
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         denom := k0+k1*ln(x);
         if denom <> 0 then
           RChart1.DrawTo (x,1/denom);
         end;
       RChart1.ShowGraf;
       LblFormula.Caption := 'y = 1/(k0 + k1*ln(x))';
       LblParams.Caption := 'k0 = '+strff(k0,1,3)+'     k1 = '+strff(k1,1,3);
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;


(*****************************************************************)
procedure TFrmMain.BButParabolFitClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1, k2 : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcParabolFit (k0, k1, k2, FitQual);
NLabFitQual.Value := FitQual;
RChart1.MoveTo (RChart1.Scale1X.RangeLow,k0+k1*RChart1.Scale1X.RangeLow+k2*sqr(RChart1.Scale1X.RangeLow));
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  RChart1.DrawTo (x,k0+k1*x+k2*sqr(x));
  end;
RChart1.ShowGraf;
LblFormula.Caption := 'y = k0 + k1*x + k2*sqr(x)';
LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3)+'    k2 = '+strff(k2,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;



(*****************************************************************)
procedure TFrmMain.BButCalcReciprLineClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;
  denom      : double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcReciLinFit (k0, k1, FitQual);
NLabFitQual.Value := FitQUal;
denom := k0+k1*RChart1.Scale1X.RangeLow;
if denom <> 0 then
  RChart1.MoveTo (RChart1.Scale1X.RangeLow,1/denom);
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  denom := k0+k1*x;
  if denom <> 0 then
    RChart1.DrawTo (x,1/denom);
  end;
RChart1.ShowGraf;
LblFormula.Caption := 'y = 1/(k0 + k1*x)';
LblParams.Caption := 'k0 = '+strff(k0,1,3)+'     k1 = '+strff(k1,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;



(*****************************************************************)
procedure TFrmMain.BButHyperClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcHyperbolFit (k0, k1, FitQual);
NLabFitQual.Value := FitQUal;
if RChart1.Scale1X.RangeLow <> 0
  then RChart1.MoveTo (RChart1.Scale1X.RangeLow,k0+k1/RChart1.Scale1X.RangeLow)
  else RChart1.MoveTo (RChart1.Scale1X.RangeLow,1e6);
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  if x <> 0
    then RChart1.DrawTo (x,k0+k1/x)
    else RChart1.DrawTo (x,1e6);
  end;
RChart1.ShowGraf;
LblFormula.Caption := 'y = k0 + k1/x';
LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;


(*****************************************************************)
procedure TFrmMain.BButLogFitClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1     : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcLogFit (k0, k1, FitQual);
NLabFitQual.Value := FitQUal;
if RChart1.Scale1X.RangeLow > 0
  then RChart1.MoveTo (RChart1.Scale1X.RangeLow,k0+k1*ln(RChart1.Scale1X.RangeLow))
  else RChart1.MoveTo (0, -1e6);
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  if x > 0 then
    RChart1.DrawTo (x,k0+k1*ln(x));
  end;
RChart1.ShowGraf;
LblFormula.Caption := 'y = k0 + k1*ln(x)';
LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;



(*****************************************************************)
procedure TFrmMain.BButGaussFitClick(Sender: TObject);
(*****************************************************************)

var
  k0, k1, k2 : double;
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x          : double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcGaussFit (k0, k1, k2, FitQual);
NLabFitQual.Value := FitQUal;
x := RChart1.Scale1X.RangeLow;
RChart1.MoveTo (x,k0*exp(-sqr(x-k1)/k2));
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  RChart1.DrawTo (x,k0*exp(-sqr(x-k1)/k2));
  end;
RChart1.ShowGraf;
LblFormula.Caption := 'y = k0*exp(-sqr(x-k1)/k2)';
LblParams.Caption := 'k0 = '+strff(k0,1,3)+'    k1 = '+strff(k1,1,3)+'    k2 = '+strff(k2,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;

(*****************************************************************)
procedure TFrmMain.BButLinFitClick(Sender: TObject);
(*****************************************************************)

var
  k,d    : double;
  FitQUal: double;

begin
DisableElements;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
Stats1.CalcLinFit (k, d, FitQual);
NLabFitQual.Value := FitQUal;
RChart1.MoveTo (RChart1.Scale1X.RangeLow,k*RChart1.Scale1X.RangeLow+d);
RChart1.DrawTo (RChart1.Scale1X.RangeHigh,k*RChart1.Scale1X.RangeHigh+d);
RChart1.ShowGraf;
LblFormula.Caption := 'y = k*x + d';
LblParams.Caption := 'k = '+strff(k,1,3)+'    d = '+strff(d,1,3);
LblFormula.Visible := True;
LblParams.Visible := true;
end;


(*****************************************************************)
procedure TFrmMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(*****************************************************************)

begin
Screen.cursor := crDefault;
end;


(*****************************************************************)
procedure TFrmMain.BButPolynomialClick(Sender: TObject);
(*****************************************************************)

var
  k          : TDoubleArray;
  FitQUal    : double;
  xstep      : double;
  i,j        : integer;
  x, xprod   : double;
  sum        : double;
  astr       : string;
  NearSing   : boolean;
  alpha      : double;

begin
DisableElements;
LblPolyOrder.Enabled := true;
SEPolyOrder.Enabled := true;
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
SetLength (k, MaxPolyFitOrder);
if not Stats1.CalcPolyFit (SEPolyOrder.Value, k, FitQual, NearSing)
  then begin
       end
  else begin
       NLabFitQual.Value := FitQual;
       xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
       x := RChart1.Scale1X.RangeLow+xstep;
       xprod := 1;
       sum := 0;
       for j:=0 to SEPolyOrder.Value do
         begin
         sum := sum + k[j]*Xprod;
         xprod := xprod*x;
         end;
       RChart1.MoveTo (x,sum);
       for i:=1 to ChartXRes do
         begin
         x := RChart1.Scale1X.RangeLow+i*xstep;
         xprod := 1;
         sum := 0;
         for j:=0 to SEPolyOrder.Value do
           begin
           sum := sum + k[j]*Xprod;
           xprod := xprod*x;
           end;
         RChart1.DrawTo (x,sum);
         end;
       RChart1.ShowGraf;
       astr := 'y = k0+k1*x';
       for i:=2 to SEPolyOrder.Value do
         astr := astr + '+k'+intToStr(i)+'*x^'+intToStr(i)+' ';
       LblFormula.Caption := astr;
       astr := '';
       for i:=0 to SEPolyOrder.Value do
         astr := astr + 'k'+intToStr(i)+'='+strff(k[i],1,3)+'  ';
       LblParams.Caption := astr;
       LblFormula.Visible := True;
       LblParams.Visible := true;
       end;
end;


(*****************************************************************)
procedure TFrmMain.SEPolyOrderChange(Sender: TObject);
(*****************************************************************)

begin
BButPolynomialClick (Sender);
end;

(******************************************************************************)
procedure TFrmMain.ShowSpline;
(******************************************************************************)

var
  FitQUal    : double;
  xstep      : double;
  i          : integer;
  x, y       : double;
  valid      : boolean;

begin
while (RChart1.TypeOfLastItem <> tkMarkAt) and
      (RChart1.TypeOfLastItem <> tkNone) do { remove any curve from graph }
  RChart1.RemoveLastItem;
SbNewPnts.Down := false;
xstep := (RChart1.Scale1X.RangeHigh-RChart1.Scale1X.RangeLow) / ChartXRes;
x := Stats1.MinX;
Stats1.SplineSmoothingFactor := SBarSmoothSpline.Position/1000;
y := Stats1.SmoothedSpline (x, FitQual, valid);
NLabFitQual.Value := FitQual;
RChart1.MoveTo (x,y);
for i:=1 to ChartXRes do
  begin
  x := RChart1.Scale1X.RangeLow+i*xstep;
  y := Stats1.SmoothedSpline (x, FitQual, valid);
  if valid then
    RChart1.DrawTo (x,y);
  end;
RChart1.ShowGraf;
end;


(******************************************************************************)
procedure TFrmMain.BButSplineClick(Sender: TObject);
(******************************************************************************)

begin
DisableElements;
SBarSmoothSpline.Enabled := true;
LblSmoothSpline.Enabled := true;
ShowSpline;
LblFormula.Visible := false;
LblParams.Visible := false;
end;

(******************************************************************************)
procedure TFrmMain.SBarSmoothSplineChange(Sender: TObject);
(******************************************************************************)

begin
ShowSpline;
end;

(******************************************************************************)
procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
(******************************************************************************)

begin
if not SDL_math2.IsLightEd then
  Stats1.ExportAsASC ('cfit.asc', 'Data exported from SDL TCurveFit', 6);
end;

(******************************************************************************)
procedure TFrmMain.FormShow(Sender: TObject);
(******************************************************************************)

var
  i : integer;
  d : double;

begin
if SDL_math2.IsLightEd
  then begin
       BButCalcReciprLine.Enabled := false;
       BButHyper.Enabled := false;
       BButLogFit.Enabled := false;
       BButGaussFit.Enabled := false;
       BButSpline.Enabled := false;
       end
  else begin
       if Stats1.ImportASC ('cfit.asc') = 0 then
         begin
         for i:=1 to Stats1.NumData do
           RChart1.MarkAt (Stats1.DataX[i], Stats1.DataY[i], 26);
         if Stats1.NumData > 0
           then begin
                d := abs(Stats1.MaxY-Stats1.MinY);
                RChart1.Scale1Y.RangeLow := Stats1.MinY-0.1*d;
                RChart1.Scale1Y.RangeHigh := Stats1.MaxY+0.1*d;
                end
           else begin
                RChart1.Scale1Y.RangeLow := -1.0;
                RChart1.Scale1Y.RangeHigh := 1.0;
                end;
         end;
       end;
end;


end.
