unit frmmain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, SDL_sdlbase, SDL_NumLab,
  SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    Panel1: TPanel;
    ButNewPoints: TButton;
    NLabArea: TNumLab;
    SBarNPoints: TScrollBar;
    NLabPoints: TNumLab;
    PnlInside: TPanel;
    procedure ButNewPointsClick(Sender: TObject);
    procedure SBarNPointsChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
  private
    dt2 : TPDblArray;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_dstruct, SDL_matrix, SDL_math2;


(******************************************************************************)
procedure TForm1.ButNewPointsClick(Sender: TObject);
(******************************************************************************)

const
  ofs = 0.06;

var
  i   : integer;
  x,y : double;
  Dt  : TPDblArray;

begin
Randomize;
SetLength (Dt, SBarNPoints.Position);
RChart1.ClearGraf;
RChart1.DataColor := clBlue;
for i:=1 to SBarNPoints.Position do
  begin
  x := 10*random;
  y := 10*random;
  Dt[i-1].X := x;
  Dt[i-1].Y := y;
  RChart1.MarkAt(x, y, 9);
  end;

dt2 := Convex2DHull (dt);

RChart1.DataColor := clLime;
RChart1.MoveTo (dt2[0].X, dt2[0].Y);
for i:=1 to 1+high(dt2) do
  RChart1.DrawTo (dt2[i-1].X, dt2[i-1].Y);
RChart1.DrawTo (dt2[0].X, dt2[0].Y);
RChart1.DataColor := clRed;
for i:=1 to 1+high(dt2) do
  RChart1.Text (dt2[i-1].X+ofs*(dt2[i-1].X-5), dt2[i-1].Y+ofs*(dt2[i-1].Y-5), 10, IntToStr(i));
RChart1.ShowGRaf;

NLabArea.Value := abs(PolygonArea(dt2));
end;

(******************************************************************************)
procedure TForm1.SBarNPointsChange(Sender: TObject);
(******************************************************************************)

begin
NLabPoints.Value := SBarNPoints.Position;
ButNewPointsClick(nil);
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

begin
ButNewPointsClick(nil);
end;

(******************************************************************************)
procedure TForm1.RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(******************************************************************************)

begin
if PointIsInsideConvexHull (rMousePosX, rMousePosY, dt2)
  then begin
       PnlInside.Color := $33FF33;;
       PnlInside.Caption := 'Mouse is inside the convex hull';
       end
  else begin
       PnlInside.Color := $3333FF;
       PnlInside.Caption := 'Mouse is outside the convex hull';
       end;
end;

end.
