(********************************************************************)
(*                                                                  *)
(*                                                                  *)
(*                          C L U S T E R                           *)
(*                                                                  *)
(*                          Version 1.1                             *)
(*                                                                  *)
(*   (C)1999..2002 H. Lohninger                       Aug-2002      *)
(*                 Vienna, Austria, Europe                          *)
(*                 http://www.lohninger.com/                        *)
(*                                                                  *)
(*     Last Update: Aug-21, 02                                      *)
(*                                                                  *)
(*  The program CLUSTER is a Delphi sample program to show the      *)
(*  usage of the clustering algorithm in our mathematical library   *)
(*  MATH2. The library is available for both Borland Delphi, Kylix  *)
(*  and Borland C++Builder. More information can be found on the    *)
(*  following Web site: http://www.lohninger.com/math2.html         *)
(*                                                                  *)
(********************************************************************)

unit ucluster;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, ComCtrls, Menus, Buttons, ExtCtrls,
  Tabnotbk, SDL_matrix, SDL_vector, SDL_NumLab,
  SDL_rchart, SDL_ntabed;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    PopupMenu1: TPopupMenu;
    Zoom111: TMenuItem;
    ZoomWind1: TMenuItem;
    Pan1: TMenuItem;
    Panel1: TPanel;
    BButExit: TBitBtn;
    BButImportData: TBitBtn;
    ProgressBar1: TProgressBar;
    PageControl1: TPageControl;
    TSDataInput: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel3: TPanel;
    NumLab1: TNumLab;
    RGClustMeth: TRadioGroup;
    RGDistance: TRadioGroup;
    ScrBarAlpha: TScrollBar;
    RChart1: TRChart;
    MM: TMemo;
    Label1: TLabel;
    NTabEd1: TNTabEd;
    ClustDist: TVector;
    ClustResult: TIntMatrix;
    DendroCoord: TVector;
    procedure BButImportDataClick(Sender: TObject);
    procedure Pan1Click(Sender: TObject);
    procedure ZoomWind1Click(Sender: TObject);
    procedure Zoom111Click(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure RGClustMethClick(Sender: TObject);
    procedure RGDistanceClick(Sender: TObject);
    procedure ScrBarAlphaChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
  private
    procedure DoClusterAnalysis;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  SDL_sdlbase, SDL_stringl, SDL_math1, SDL_math2;


(********************************************************************)
procedure TForm1.BButImportDataClick(Sender: TObject);
(********************************************************************)

begin
PageControl1.ActivePage := TSDataInput;
OpenDialog1.Filter := 'DataLab ASC Files|*.asc';
if OpenDialog1.Execute then
  begin
  NTabEd1.Data.ImportASC (OpenDialog1.FileName);
  DoClusterAnalysis;
  end;
end;


(********************************************************************)
procedure ShowProgress (cnt: double); far;
(********************************************************************)

begin      { here the display of the progress takes place }
Form1.ProgressBar1.Position := round(100.0*cnt/Form1.NTabEd1.NrOfRows);
Application.ProcessMessages;
end;


(********************************************************************)
procedure TForm1.DoClusterAnalysis;
(********************************************************************)

const
  DistMeasureID : array[dmJaccard..dmDice] of string =
                  ('Jaccard', 'Manhattan', 'Euclidian', 'squared Euclidian', 'Dice');
  ClustMethID : array[cmSingleLink..cmFlexLink] of string =
                  ('single linkage', 'complete linkage',
                   'Ward''s method', 'average linkage',
                   'flexible strategy');

var
  i           : integer;
  ix1, ix2    : integer;
  dist1,dist2 : double;
  DistMeasure : TDistMode;
  ClustMeth   : TClusterMethod;

begin
ClustResult.Resize (3, NTabEd1.NrOfRows);
ClustDist.NrOfElem := NTabEd1.NrOfRows;
DendroCoord.Resize (NTabEd1.NrOfRows);
ProcStat := 0;
MathFeedbackProc := ShowProgress;
DistMeasure := TDistMode(RGDistance.ItemIndex);
case RGClustMeth.ItemIndex of
  0 : ClustMeth := cmSingleLink;
  1 : ClustMeth := cmCompleteLink;
  2 : ClustMeth := cmAvgLink;
  3 : ClustMeth := cmWard;
  4 : ClustMeth := cmFlexLink;
else ClustMeth := cmSingleLink;
end;
if AgglomClustering (nil, NTabEd1.Data.NumericData, DistMeasure, ClustMeth, Numlab1.Value, ClustResult, ClustDist, DendroCoord, nil, nil) = 0 then
  begin
  MM.Clear;
  MM.Lines.Add (' distance measure: '+ DistMeasureID[DistMeasure]);
  MM.Lines.Add ('clustering method: '+ ClustMethID[ClustMeth]);
  MM.Lines.Add ('');
  MM.Lines.Add (' Obj.1 Obj.2  New Cluster   Distance');
  for i:=1 to NTabEd1.NrOfRows-1 do
    begin
    MM.Lines.Add (strff (ClustResult.Elem[1,i],4,0)+'  '+
                  strff (ClustResult.Elem[2,i],4,0)+'      '+
                  strff (ClustResult.Elem[3,i],4,0)+'        '+
                  strff (ClustDist.Elem[i],1,4));
    end;
  Rchart1.ClearGraf;
  for i:=1 to NTabEd1.NrOfRows-1 do
    begin
    ix1 := ClustResult.Elem[1,i];
    dist1 := 0;
    if ix1 > NTabEd1.NrOfRows
      then dist1 := ClustDist.Elem[ix1-NTabEd1.NrOfRows]
      else RChart1.Text (-0.02*ClustDist.Elem[NTabEd1.NrOfRows-1], DendroCoord.Elem[ix1], 8, IntToStr (ClustResult.Elem[1,i]));
    dist2 := ClustDist.Elem[ClustResult.Elem[3,i]-NTabEd1.NrOfRows];
    RChart1.Line (dist1,DendroCoord.Elem[ix1],dist2,DendroCoord.Elem[ix1]);
    ix2 := ClustResult.Elem[2,i];
    dist1 := 0;
    if ix2 > NTabEd1.NrOfRows
      then dist1 := ClustDist.Elem[ix2-NTabEd1.NrOfRows]
      else RChart1.Text (-0.02*ClustDist.Elem[NTabEd1.NrOfRows-1], DendroCoord.Elem[ix2], 8, IntToStr (ClustResult.Elem[2,i]));
    RChart1.Line (dist1,DendroCoord.Elem[ix2],dist2,DendroCoord.Elem[ix2]);
    RChart1.Line (dist2,DendroCoord.Elem[ix1],dist2,DendroCoord.Elem[ix2]);
    end;
  Rchart1.SHowGraf;
  end;
MathFeedbackProc := nil;
Zoom111Click (self);
ProgressBar1.Position := 0;
end;

(********************************************************************)
procedure TForm1.Pan1Click(Sender: TObject);
(********************************************************************)

begin
RChart1.MouseAction := maPan;
end;

(********************************************************************)
procedure TForm1.ZoomWind1Click(Sender: TObject);
(********************************************************************)

begin
RChart1.MouseAction := maZoomWindPos;
end;

(********************************************************************)
procedure TForm1.Zoom111Click(Sender: TObject);
(********************************************************************)

begin
RChart1.SetRange (1,
                  -0.08*ClustDist.Elem[NTabEd1.NrOfRows-1],0,
                  1.03*ClustDist.Elem[NTabEd1.NrOfRows-1],NTabEd1.NrOfRows+1);
end;

(********************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(********************************************************************)

begin
close;
end;

(********************************************************************)
procedure TForm1.RGClustMethClick(Sender: TObject);
(********************************************************************)

begin
if RGClustMeth.ItemIndex = 4
  then ScrBarAlpha.Enabled := true
  else ScrBarAlpha.Enabled := false;
DoClusterAnalysis;
end;

(********************************************************************)
procedure TForm1.RGDistanceClick(Sender: TObject);
(********************************************************************)

begin
DoClusterAnalysis;
end;

(********************************************************************)
procedure TForm1.ScrBarAlphaChange(Sender: TObject);
(********************************************************************)

begin
Numlab1.Value := ScrBarAlpha.Position/100;
if RGClustMeth.ItemIndex = 4 then
  DoClusterAnalysis;
end;

(********************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(********************************************************************)

var
  i, j : integer;

begin
for j:=1 to NTabEd1.NrOfRows do
  for i:=1 to NTabEd1.NrOfColumns do
    NTabEd1.Elem[i,j] := random;
end;

(********************************************************************)
procedure TForm1.PageControl1Change(Sender: TObject);
(********************************************************************)

begin
DoClusterAnalysis;
end;

end.
