//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "frmclock.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DrawClock(TDateTime T)
{
const int NCircStep = 60;
const float HourIndexLeng = 0.45;
const float MinIndexLeng = 0.65;
const float SecIndexLeng = 0.75;
const float TicksLeng = 0.06;

int  i, tsize;
unsigned short  Hour, Min, Sec, MSec;
int  ao;

PCClk->ClearGraf();
PCClk->MoveTo (1,0);
PCClk->DataColor = clNavy;
for (i=1; i<=NCircStep; i++)
  {
  PCClk->MoveTo (1-TicksLeng, 360.0*i/NCircStep);
  PCClk->DrawTo (1, 360.0*i/NCircStep);
  }
tsize = 1+int(0.5+0.02*sqrt((1.0*Width)*(1.0*Width)+(1.0*Height)*(1.0*Height)));
for (i=1; i<=12; i++)
  {
  PCClk->MarkAt (0.90,360.0*i/12,8);
  PCClk->Text (0.80,360.0*i/12,tsize,IntToStr(i));
  }
PCClk->DataColor = clBlue;

DecodeTime (T, Hour, Min, Sec, MSec);
PCClk->LineWidth =tsize;
PCClk->Line (0,0,HourIndexLeng,360.0*(Hour+1.0*Min/60)/12);
PCClk->Line (0,0,MinIndexLeng, 360.0*(Min+1.0*Sec/60)/60);
PCClk->LineWidth =2;
PCClk->DataColor = clMaroon;
PCClk->MarkAt (0,0,24);
PCClk->Line (0,0, SecIndexLeng, 6*Sec);
PCClk->LineWidth =1;
switch (RGClockMode->ItemIndex)
  {
  case 0 : {
           PCClk->AngleOffset = -90;
           break;
           }
  case 1 : {
           PCClk->AngleOffset = SBarAngOfs->Position;
           break;
           }
  case 2 : {
           ao = 90-Sec*6;
           if (ao > 360) ao = ao-360;
           PCClk->AngleOffset = ao;
           }
  }
PCClk->ShowGraf();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBExitClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBResetClick(TObject *Sender)
{
PCClk->AngleOffset = -90;
SBarAngOfs->Position = -90;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{
PCClk->CenterChart();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBarAngOfsChange(TObject *Sender)
{
PCClk->AngleOffset = SBarAngOfs->Position;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
DrawClock(Now());
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
DrawClock(Now());
}
//---------------------------------------------------------------------------
