unit Frmclock;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, 
  SDL_polchart;

type
  TFrmMainClock = class(TForm)
    Panel1: TPanel;
    SBExit: TSpeedButton;
    Timer1: TTimer;
    PCClk: TPolChart;
    SBarAngOfs: TScrollBar;
    SBReset: TSpeedButton;
    RGClockMode: TRadioGroup;
    procedure SBExitClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SBarAngOfsChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SBResetClick(Sender: TObject);
  private
    procedure DrawClock (T: TDateTime);
  public
    { Public declarations }
  end;

var
  FrmMainClock: TFrmMainClock;

implementation

{$R *.DFM}

(***************************************************************)
procedure TFrmMainClock.SBExitClick(Sender: TObject);
(***************************************************************)

begin
close;
end;

(***************************************************************)
procedure TFrmMainClock.FormActivate(Sender: TObject);
(***************************************************************)

begin
DrawClock (Now);
end;

(***************************************************************)
procedure TFrmMainClock.DrawClock (T: TDateTime);
(***************************************************************)

const
  NCircStep = 60;
  HourIndexLeng = 0.45;
  MinIndexLeng = 0.65;
  SecIndexLeng = 0.75;
  TicksLeng = 0.06;

var
  i, tsize : integer;
  Hour, Min, Sec, MSec: Word;
  ao    : integer;

begin
PCClk.ClearGraf;
PCClk.MoveTo (1,0);
PCClk.DataColor := clNavy;
for i:=1 to NCircStep do
  begin
  PCClk.MoveTo (1-TicksLeng, 360*i/NCircStep);
  PCClk.DrawTo (1, 360*i/NCircStep);
  end;
tsize := 1+round(0.02*sqrt(sqr(1.0*width)+sqr(1.0*height)));
for i:=1 to 12 do
  begin
  PCClk.MarkAT (0.90,360*i/12,8);
  PCClk.Text (0.80,360*i/12,tsize,IntToStr(i));
  end;
PCClk.DataColor := clBlue;

DecodeTime (T, Hour, Min, Sec, MSec);
PCClk.LineWidth :=tsize;
PCClk.Line (0,0,HourIndexLeng,360*(Hour+1.0*min/60)/12);
PCClk.Line (0,0,MinIndexLeng, 360*(Min+1.0*Sec/60)/60);
PCClk.LineWidth :=2;
PCClk.DataColor := clMaroon;
PCClk.MarkAt (0,0,24);
PCClk.Line (0,0, SecIndexLeng, 360*Sec/60);
PCClk.LineWidth :=1;
case RGClockMode.itemIndex of
  0 : begin
      PcClk.AngleOffset := -90;
      end;
  1 : begin
      PcClk.AngleOffset := SBarAngOfs.Position;
      end;
  2 : begin
      ao := 90-Sec*6;
      if ao > 360 then
        ao := ao-360;
      PcClk.AngleOffset := ao;
      end;
end;
PCClk.ShowGraf;
end;


(***************************************************************)
procedure TFrmMainClock.Timer1Timer(Sender: TObject);
(***************************************************************)

begin
DrawClock(Now);
end;

(***************************************************************)
procedure TFrmMainClock.SBarAngOfsChange(Sender: TObject);
(***************************************************************)

begin
PCClk.AngleOffset := SBarAngOfs.Position;
end;

(***************************************************************)
procedure TFrmMainClock.FormResize(Sender: TObject);
(***************************************************************)

begin
PCClk.CenterChart;
end;

(***************************************************************)
procedure TFrmMainClock.SBResetClick(Sender: TObject);
(***************************************************************)

begin
PCClk.AngleOffset := -90;
SBarAngOfs.Position := -90;
end;

end.
