unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons, ExtCtrls, Menus,
  SDL_Colsel, SDL_rchart, SDL_boxplot, SDL_NumLab, SDL_ntabed, SDL_urllab;

type
  TForm1 = class(TForm)
    NTabEd1: TNTabEd;
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    BoxPlot1: TBoxPlot;
    SBarBoxWid: TScrollBar;
    RGOrient: TRadioGroup;
    RGGrid: TRadioGroup;
    GroupBox1: TGroupBox;
    LblBodyColor: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CBoxPerc90: TCheckBox;
    BButSymb90Perc: TBitBtn;
    CboxMean: TCheckBox;
    CBoxMedian: TCheckBox;
    CBoxMinMax: TCheckBox;
    CSel90Perc: TColSel;
    BButSymbMean: TBitBtn;
    CSelMean: TColSel;
    BButSymbMedian: TBitBtn;
    CSelMedian: TColSel;
    BButSymbMinMax: TBitBtn;
    CSelMinMax: TColSel;
    CSelBody: TColSel;
    CSelFrame: TColSel;
    CSelBkg: TColSel;
    CSelGrid: TColSel;
    CBoxShortTicks: TCheckBox;
    BButExit: TBitBtn;
    PopupMenu1: TPopupMenu;
    Zoom111: TMenuItem;
    Pan1: TMenuItem;
    ZoomWindow1: TMenuItem;
    PanData1: TMenuItem;
    MoveCrosshair1: TMenuItem;
    NLabCursor: TNumLab;
    CBoxLabels: TCheckBox;
    CopytoClipboard1: TMenuItem;
    CBoxIndivColors: TCheckBox;
    MoveLabels1: TMenuItem;
    Print1: TMenuItem;
    PDiag: TPrintDialog;
    UrlLab2: TUrlLab;
    procedure SBarBoxWidChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CBoxPerc90Click(Sender: TObject);
    procedure BButSymb90PercClick(Sender: TObject);
    procedure RGOrientClick(Sender: TObject);
    procedure CboxMeanClick(Sender: TObject);
    procedure CBoxMedianClick(Sender: TObject);
    procedure CBoxMinMaxClick(Sender: TObject);
    procedure RGGridClick(Sender: TObject);
    procedure CSel90PercChange(Sender: TObject);
    procedure CSelMeanChange(Sender: TObject);
    procedure CSelMedianChange(Sender: TObject);
    procedure CSelMinMaxChange(Sender: TObject);
    procedure CSelBodyChange(Sender: TObject);
    procedure CSelFrameChange(Sender: TObject);
    procedure CSelBkgChange(Sender: TObject);
    procedure CBoxShortTicksClick(Sender: TObject);
    procedure CSelGridChange(Sender: TObject);
    procedure BButExitClick(Sender: TObject);
    procedure Zoom111Click(Sender: TObject);
    procedure Pan1Click(Sender: TObject);
    procedure ZoomWindow1Click(Sender: TObject);
    procedure PanData1Click(Sender: TObject);
    procedure MoveCrosshair1Click(Sender: TObject);
    procedure BoxPlot1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
    procedure CBoxLabelsClick(Sender: TObject);
    procedure CopytoClipboard1Click(Sender: TObject);
    procedure CBoxIndivColorsClick(Sender: TObject);
    procedure BoxPlot1BeforeBoxDraw(Sender: TObject; Column: Integer;
      var IntColorLines, IntColorBody, IntColorMinMax, IntColor90Perc,
      IntColorMean, IntColorMedian: TColor);
    procedure BButSymbMeanClick(Sender: TObject);
    procedure BButSymbMedianClick(Sender: TObject);
    procedure BButSymbMinMaxClick(Sender: TObject);
    procedure MoveLabels1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  printers, SDL_sdlbase, SDL_math1, syselect;

(******************************************************************************)
procedure TForm1.SBarBoxWidChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.BoxWidth := SBarBoxWid.Position/100;
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

var
  i,j   : integer;
  yrand : double;

begin
Randomize;
for j:=1 to NTabed1.NrOfColumns do
  begin
  yrand := random;
  for i:=1 to NTabEd1.NrOfRows do
    NTabEd1.Data[j,i] := gRandom+j-yrand;
  end;
BoxPlot1.AssignAnotherDataTable(NTabEd1.Data);
BoxPlot1.AutoRange(10);
BButSymb90Perc.Glyph := CreateMarkAsBitMap(BoxPlot1.Symbol90Perc,clBlack,clBtnFace,1);
BButSymbMean.Glyph := CreateMarkAsBitMap(BoxPlot1.SymbolMean,clBlack,clBtnFace,1);
BButSymbMedian.Glyph := CreateMarkAsBitMap(BoxPlot1.SymbolMedian,clBlack,clBtnFace,1);
BButSymbMinMax.Glyph := CreateMarkAsBitMap(BoxPlot1.SymbolMin,clBlack,clBtnFace,1);
BButSymbMinMax.Glyph := CreateMarkAsBitMap(BoxPlot1.SymbolMax,clBlack,clBtnFace,1);
end;

(******************************************************************************)
procedure TForm1.CBoxPerc90Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.Show90Perc := CBoxPerc90.Checked;
end;

(******************************************************************************)
procedure TForm1.BButSymb90PercClick(Sender: TObject);
(******************************************************************************)

begin
FrmSySelect.MarkSel1.Selected := BoxPlot1.Symbol90Perc;
if FrmSySelect.ShowModal = mrOK then
  begin
  BButSymb90Perc.Glyph := CreateMarkAsBitMap(FrmSySelect.MarkSel1.Selected,clBlack,clBtnFace,1);
  BoxPlot1.Symbol90Perc := FrmSySelect.MarkSel1.Selected;
  end;
end;

(******************************************************************************)
procedure TForm1.RGOrientClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.Orientation := TBoxPlotOrientation(RGOrient.ItemIndex);
if (BoxPlot1.MouseAction = maPanHoriz) or (BoxPlot1.MouseAction = maPanVert) then
  begin
  case BoxPlot1.Orientation of
    bpltHorizontal : BoxPlot1.MouseAction := maPanHoriz;
      bpltVertical : BoxPlot1.MouseAction := maPanVert;
  end;
  end;
end;

(******************************************************************************)
procedure TForm1.CboxMeanClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ShowMean := CBoxMean.Checked;
end;

(******************************************************************************)
procedure TForm1.CBoxMedianClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ShowMedian := CBoxMedian.Checked;
end;

(******************************************************************************)
procedure TForm1.CBoxMinMaxClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ShowMinMax := CBoxMinMax.Checked;
end;

(******************************************************************************)
procedure TForm1.RGGridClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.GridStyle := TBoxPlotGridStyle(RGGrid.ItemIndex);
end;

(******************************************************************************)
procedure TForm1.CSel90PercChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.Color90Perc := CSel90Perc.SelColor;
end;

(******************************************************************************)
procedure TForm1.CSelMeanChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ColorMean := CSelMean.SelColor;
end;

(******************************************************************************)
procedure TForm1.CSelMedianChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ColorMedian := CSelMedian.SelColor;
end;

(******************************************************************************)
procedure TForm1.CSelMinMaxChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ColorMinMax := CSelMinMax.SelColor;
end;


(******************************************************************************)
procedure TForm1.CSelBodyChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ColorBody := CSelBody.SelColor;
end;

(******************************************************************************)
procedure TForm1.CSelFrameChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ColorLines := CSelFrame.SelColor;
end;

(******************************************************************************)
procedure TForm1.CSelBkgChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.ChartColor := CSelBkg.SelColor;
end;

(******************************************************************************)
procedure TForm1.CBoxShortTicksClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.Scale1X.ShortTicks := CBoxShortTicks.Checked;
BoxPlot1.Scale1Y.ShortTicks := CBoxShortTicks.Checked;
end;

(******************************************************************************)
procedure TForm1.CSelGridChange(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.GridColor := CSelGrid.SelColor;
end;

(******************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TForm1.Zoom111Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.AutoRange(10);
end;

(******************************************************************************)
procedure TForm1.Pan1Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.MouseAction := maPan;
BoxPlot1.CrossHair1.Mode := chOff;
end;


(******************************************************************************)
procedure TForm1.ZoomWindow1Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.MouseAction := maZoomWindPos;
BoxPlot1.CrossHair1.Mode := chOff;
end;

(******************************************************************************)
procedure TForm1.PanData1Click(Sender: TObject);
(******************************************************************************)

begin
case BoxPlot1.Orientation of
  bpltHorizontal : BoxPlot1.MouseAction := maPanHoriz;
    bpltVertical : BoxPlot1.MouseAction := maPanVert;
end;
BoxPlot1.CrossHair1.Mode := chOff;
end;


(******************************************************************************)
procedure TForm1.MoveLabels1Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.MouseAction := maDragLabel;
BoxPlot1.CrossHair1.Mode := chOff;
end;


(******************************************************************************)
procedure TForm1.MoveCrosshair1Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.MouseAction := maDragCrossH;
BoxPlot1.CrossHair1.Mode := chBoth;
end;

(******************************************************************************)
procedure TForm1.BoxPlot1MouseMoveInChart(Sender: TObject;
  InChart: Boolean; Shift: TShiftState; rMousePosX, rMousePosY: Double);
(******************************************************************************)

begin
case BoxPlot1.Orientation of
  bpltHorizontal : NlabCursor.Value := rMousePosX;
    bpltVertical : NLabCursor.Value := rMousePosY;
end;

end;

(******************************************************************************)
procedure TForm1.CBoxLabelsClick(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.Labels.Visible := CBoxLabels.Checked;
end;

(******************************************************************************)
procedure TForm1.CopytoClipboard1Click(Sender: TObject);
(******************************************************************************)

begin
BoxPlot1.CopyToClipboard(false);
end;


(******************************************************************************)
procedure TForm1.CBoxIndivColorsClick(Sender: TObject);
(******************************************************************************)

begin
CSelBody.Enabled := not CboxIndivColors.Checked;
LblBodyColor.Enabled := not CboxIndivColors.Checked;
BoxPlot1.Update;
end;

(******************************************************************************)
procedure TForm1.BoxPlot1BeforeBoxDraw(Sender: TObject; Column: Integer;
  var IntColorLines, IntColorBody, IntColorMinMax, IntColor90Perc,
  IntColorMean, IntColorMedian: TColor);
(******************************************************************************)

const
  BoxColors : array[1..5] of TColor = (clRed, $55EEEE, clLime, clYellow, $55EEDD);

begin
if CBoxIndivColors.Checked then
  begin
  if column < 1 then
    Column := 1;
  if Column > 5 then
    Column := 5;
  IntColorBody := BoxColors[Column];
  end;
end;


(******************************************************************************)
procedure TForm1.BButSymbMeanClick(Sender: TObject);
(******************************************************************************)

begin
FrmSySelect.MarkSel1.Selected := BoxPlot1.SymbolMean;
if FrmSySelect.ShowModal = mrOK then
  begin
  BButSymbMean.Glyph := CreateMarkAsBitMap(FrmSySelect.MarkSel1.Selected,clBlack,clBtnFace,1);
  BoxPlot1.SymbolMean := FrmSySelect.MarkSel1.Selected;
  end;
end;

(******************************************************************************)
procedure TForm1.BButSymbMedianClick(Sender: TObject);
(******************************************************************************)

begin
FrmSySelect.MarkSel1.Selected := BoxPlot1.SymbolMedian;
if FrmSySelect.ShowModal = mrOK then
  begin
  BButSymbMedian.Glyph := CreateMarkAsBitMap(FrmSySelect.MarkSel1.Selected,clBlack,clBtnFace,1);
  BoxPlot1.SymbolMedian := FrmSySelect.MarkSel1.Selected;
  end;
end;

(******************************************************************************)
procedure TForm1.BButSymbMinMaxClick(Sender: TObject);
(******************************************************************************)

begin
FrmSySelect.MarkSel1.Selected := BoxPlot1.SymbolMin;
if FrmSySelect.ShowModal = mrOK then
  begin
  BButSymbMinMax.Glyph := CreateMarkAsBitMap(FrmSySelect.MarkSel1.Selected,clBlack,clBtnFace,1);
  BoxPlot1.SymbolMin := FrmSySelect.MarkSel1.Selected;
  BoxPlot1.SymbolMax := FrmSySelect.MarkSel1.Selected;
  end;
end;

(******************************************************************************)
procedure TForm1.Print1Click(Sender: TObject);
(******************************************************************************)

begin
if PDiag.Execute then
  begin
  Printer.Title := 'BoxPlot';
  BoxPlot1.PrintIt(1.0, true);
  end;
end;

end.

