//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "mainfrm.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SDL_Colsel"
#pragma link "SDL_geoatlas"
#pragma link "SDL_NumLab"
#pragma resource "*.dfm"
TForm1 *Form1;
const char * EXPLN_MFZOOM = "mouse function: zoom in (left click) and out (right click)";
const char * EXPLN_MFPOI = "mouse function: pan the current map";
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GAPointerButClick(TObject *Sender)
{
PnlExplain->Caption = EXPLN_MFPOI;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GAZoomButClick(TObject *Sender)
{
PnlExplain->Caption = EXPLN_MFZOOM;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CBoxCmdVisClick(TObject *Sender)
{
GA->CmdPanel->Visible = CBoxCmdVis->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GAMouseMove(TObject *Sender, TShiftState Shift,
      int X, int Y)
{
bool valid;

NLabPosLong->Value = GA->CurrentMap->CalcLongitude (X + GA->CurrentMap->TopLeft.x, Y+GA->CurrentMap->TopLeft.y, valid);
NLabPosLat->Value = GA->CurrentMap->CalcLatitude (X+GA->CurrentMap->TopLeft.x, Y+GA->CurrentMap->TopLeft.y, valid);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CBoxOLVisibleClick(TObject *Sender)
{
GA->MapOutlineVisible = CBoxOLVisible->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ColSel1Change(TObject *Sender)
{
GA->MapOutlineColor = ColSel1->SelColor;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BButLoadMapsClick(TObject *Sender)
{
GA->CurrentMap->CalibModel = cmParabolicIp;
if (FileExists ("data\europe.xml"))
  {
  GA->RegisterMap ("data\europe.xml");
  }
else
  {
  GA->RegisterMap ("europe.xml");
  }
if (FileExists ("data\austria_1500000.xml"))
  {
  GA->RegisterMap ("data\austria_1500000.xml");
  }
else
  {
  GA->RegisterMap ("austria_1500000.xml");
  }
if (FileExists ("data\switzerland.xml"))
  {
  GA->RegisterMap ("data\switzerland.xml");
  }
else
  {
  GA->RegisterMap ("switzerland.xml");
  }
if (FileExists ("data\austria_noe.xml"))
  {
  GA->RegisterMap ("data\austria_noe.xml");
  }
else
  {
  GA->RegisterMap ("austria_noe.xml");
  }
if (FileExists ("data\vienna_surround.xml"))
  {
  GA->RegisterMap ("data\vienna_surround.xml");
  }
else
  {
  GA->RegisterMap ("vienna_surround.xml");
  }
GA->SelectMap(1);
GA->CurrentMap->BringLocationToCenter (48, 14);
GA->Align = alClient;
if (GA->PointerButton->Down)
  {
  PnlExplain->Caption = EXPLN_MFPOI;
  }
else
  {
  PnlExplain->Caption = EXPLN_MFZOOM;
  }
}
//---------------------------------------------------------------------------
