unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  SDL_geomap, SDL_Colsel, SDL_NumLab, SDL_geoatlas;

type
  TFrmMain = class(TForm)
    GA: TGeoAtlas;
    Panel1: TPanel;
    CBoxOLVisible: TCheckBox;
    ColSel1: TColSel;
    NLabPosLong: TNumLab;
    CBoxCmdVis: TCheckBox;
    Label1: TLabel;
    NLabPosLat: TNumLab;
    BButLoadMaps: TBitBtn;
    PnlExplain: TPanel;
    procedure BbutLoadMapsClick(Sender: TObject);
    procedure ColSel1Change(Sender: TObject);
    procedure CBoxOLVisibleClick(Sender: TObject);
    procedure GAMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure CBoxCmdVisClick(Sender: TObject);
    procedure GAZoomButClick(Sender: TObject);
    procedure GAPointerButClick(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  FrmMain: TFrmMain;



implementation

{$R *.dfm}


const
  EXPLN_MFZOOM = 'mouse function: zoom in (left click) and out (right click)';
  EXPLN_MFPOI = 'mouse function: pan the current map';

(******************************************************************************)
procedure TFrmMain.BbutLoadMapsClick(Sender: TObject);
(******************************************************************************)

begin
GA.CurrentMap.CalibModel := cmParabolicIp;
if FileExists ('data\europe.xml')
  then GA.RegisterMap ('data\europe.xml')
  else GA.RegisterMap ('europe.xml');
if FileExists ('data\austria_1500000.xml')
  then GA.RegisterMap ('data\austria_1500000.xml')
  else GA.RegisterMap ('austria_1500000.xml');
if FileExists ('data\switzerland.xml')
  then GA.RegisterMap ('data\switzerland.xml')
  else GA.RegisterMap ('switzerland.xml');
if FileExists ('data\austria_noe.xml')
  then GA.RegisterMap ('data\austria_noe.xml')
  else GA.RegisterMap ('austria_noe.xml');
if FileExists ('data\vienna_surround.xml')
  then GA.RegisterMap ('data\vienna_surround.xml')
  else GA.RegisterMap ('vienna_surround.xml');
GA.SelectMap(1);
GA.CurrentMap.BringLocationToCenter (48, 14);
GA.Align := alClient;
if GA.PointerButton.Down
  then PnlExplain.Caption := EXPLN_MFPOI
  else PnlExplain.Caption := EXPLN_MFZOOM;
end;

(******************************************************************************)
procedure TFrmMain.ColSel1Change(Sender: TObject);
(******************************************************************************)

begin
GA.MapOutlineColor := ColSel1.SelColor;
end;

(******************************************************************************)
procedure TFrmMain.CBoxOLVisibleClick(Sender: TObject);
(******************************************************************************)

begin
GA.MapOutlineVisible := CBoxOLVisible.Checked;
end;

(******************************************************************************)
procedure TFrmMain.GAMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(******************************************************************************)

var
  valid : boolean;

begin
NLabPosLong.Value := GA.CurrentMap.CalcLongitude (x+GA.CurrentMap.TopLeft.X, y+GA.CurrentMap.TopLeft.Y, valid);
NLabPosLat.Value := GA.CurrentMap.CalcLatitude (x+GA.CurrentMap.TopLeft.X, y+GA.CurrentMap.TopLeft.Y, valid);
end;

(******************************************************************************)
procedure TFrmMain.CBoxCmdVisClick(Sender: TObject);
(******************************************************************************)

begin
GA.CmdPanel.Visible := CBoxCmdVis.Checked;
end;




(******************************************************************************)
procedure TFrmMain.GAZoomButClick(Sender: TObject);
(******************************************************************************)

begin
PnlExplain.Caption := EXPLN_MFZOOM;
end;

(******************************************************************************)
procedure TFrmMain.GAPointerButClick(Sender: TObject);
(******************************************************************************)

begin
PnlExplain.Caption := EXPLN_MFPOI;
end;

end.
